/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointGoal;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;

public class LinearWaypointProvider
implements WaypointProvider,
Iterable<Waypoint> {
    private WaypointGoal currentGoal;
    private NPC npc;
    private final List<Waypoint> waypoints = Lists.newArrayList();

    @Override
    public Editor createEditor(final Player player) {
        return new Editor(){
            int editingSlot;
            private static final int LARGEST_SLOT = 8;
            {
                this.editingSlot = LinearWaypointProvider.this.waypoints.size() - 1;
            }

            @Override
            public void begin() {
                player.sendMessage(ChatColor.AQUA + "Entered the linear waypoint editor!");
                Messaging.send((CommandSender)player, "<e>Left click<a> to add a waypoint, <e>right click<a> to remove.");
            }

            @Override
            public void end() {
                player.sendMessage(ChatColor.AQUA + "Exited the linear waypoint editor.");
            }

            private String formatLoc(Location location) {
                return String.format("<e>%d<a>, <e>%d<a>, <e>%d<a>", location.getBlockX(), location.getBlockY(), location.getBlockZ());
            }

            @EventHandler
            public void onNPCDespawn(NPCDespawnEvent event) {
                if (event.getNPC().equals(LinearWaypointProvider.this.npc)) {
                    this.end();
                }
            }

            @EventHandler
            public void onPlayerInteract(PlayerInteractEvent event) {
                if (!event.getPlayer().equals(player) || event.getAction() == Action.PHYSICAL) {
                    return;
                }
                if (event.getAction() == Action.LEFT_CLICK_BLOCK || event.getAction() == Action.LEFT_CLICK_AIR) {
                    if (event.getClickedBlock() == null) {
                        return;
                    }
                    Location at = event.getClickedBlock().getLocation();
                    LinearWaypointProvider.this.waypoints.add(Math.max(0, this.editingSlot), new Waypoint(at));
                    this.editingSlot = Math.min(this.editingSlot + 1, LinearWaypointProvider.this.waypoints.size());
                    Messaging.send((CommandSender)player, String.format("<e>Added<a> a waypoint at (" + this.formatLoc(at) + ") (<e>%d<a>, <e>%d<a>)", this.editingSlot + 1, LinearWaypointProvider.this.waypoints.size()));
                } else if (LinearWaypointProvider.this.waypoints.size() > 0) {
                    this.editingSlot = Math.min(0, Math.max(LinearWaypointProvider.this.waypoints.size() - 1, this.editingSlot));
                    LinearWaypointProvider.this.waypoints.remove(this.editingSlot);
                    this.editingSlot = Math.max(0, this.editingSlot - 1);
                    Messaging.send((CommandSender)player, String.format("<e>Removed<a> a waypoint (<e>%d<a> remaining) (<e>%d<a>)", LinearWaypointProvider.this.waypoints.size(), this.editingSlot + 1));
                }
                LinearWaypointProvider.this.currentGoal.onProviderChanged();
            }

            @EventHandler
            public void onPlayerItemHeldChange(PlayerItemHeldEvent event) {
                if (!event.getPlayer().equals(player) || LinearWaypointProvider.this.waypoints.size() == 0) {
                    return;
                }
                int previousSlot = event.getPreviousSlot();
                int newSlot = event.getNewSlot();
                if (previousSlot == 0 && newSlot == 8) {
                    --this.editingSlot;
                } else if (previousSlot == 8 && newSlot == 0) {
                    ++this.editingSlot;
                } else {
                    int diff = newSlot - previousSlot;
                    if (Math.abs(diff) != 1) {
                        return;
                    }
                    this.editingSlot += diff > 0 ? 1 : -1;
                }
                if (this.editingSlot >= LinearWaypointProvider.this.waypoints.size()) {
                    this.editingSlot = 0;
                }
                if (this.editingSlot < 0) {
                    this.editingSlot = LinearWaypointProvider.this.waypoints.size() - 1;
                }
                Messaging.send((CommandSender)player, "<a>Editing slot set to " + StringHelper.wrap(this.editingSlot) + " (" + this.formatLoc(((Waypoint)LinearWaypointProvider.this.waypoints.get(this.editingSlot)).getLocation()) + ").");
            }
        };
    }

    @Override
    public Iterator<Waypoint> iterator() {
        return this.waypoints.iterator();
    }

    @Override
    public void load(DataKey key) {
        for (DataKey root : key.getRelative("points").getIntegerSubKeys()) {
            root = root.getRelative("location");
            this.waypoints.add(new Waypoint(new Location(Bukkit.getWorld((String)root.getString("world")), root.getDouble("x"), root.getDouble("y"), root.getDouble("z"), (float)root.getDouble("yaw", 0.0), (float)root.getDouble("pitch", 0.0))));
        }
    }

    @Override
    public void onSpawn(NPC npc) {
        this.npc = npc;
        if (this.currentGoal == null) {
            this.currentGoal = new WaypointGoal(this, npc.getNavigator());
            CitizensAPI.registerEvents(this.currentGoal);
        }
        npc.getDefaultGoalController().addGoal(this.currentGoal, 1);
    }

    @Override
    public void save(DataKey key) {
        key.removeKey("points");
        key = key.getRelative("points");
        for (int i = 0; i < this.waypoints.size(); ++i) {
            Location location = this.waypoints.get(i).getLocation();
            DataKey root = key.getRelative(Integer.toString(i) + ".location");
            root.setString("world", location.getWorld().getName());
            root.setDouble("x", location.getX());
            root.setDouble("y", location.getY());
            root.setDouble("z", location.getZ());
            root.setDouble("yaw", location.getYaw());
            root.setDouble("pitch", location.getPitch());
        }
    }
}

