/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.editor.Equipable;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Messaging;
import net.minecraft.server.EntityEnderman;
import net.minecraft.server.PathfinderGoalSelector;
import net.minecraft.server.World;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class CitizensEndermanNPC
extends CitizensMobNPC
implements Equipable {
    public CitizensEndermanNPC(int id, String name) {
        super(id, name, EntityEndermanNPC.class);
    }

    @Override
    public void equip(Player equipper) {
        ItemStack set;
        ItemStack hand = equipper.getItemInHand();
        if (!hand.getType().isBlock()) {
            Messaging.sendError((CommandSender)equipper, "Invalid block!");
            return;
        }
        MaterialData carried = this.getBukkitEntity().getCarriedMaterial();
        if (carried.getItemType() == Material.AIR) {
            if (hand.getType() == Material.AIR) {
                Messaging.sendError((CommandSender)equipper, "Invalid block!");
                return;
            }
        } else {
            equipper.getWorld().dropItemNaturally(this.getBukkitEntity().getLocation(), carried.toItemStack(1));
            this.getBukkitEntity().setCarriedMaterial(hand.getData());
        }
        if ((set = hand).getType() != Material.AIR) {
            if (hand.getAmount() > 1) {
                hand.setAmount(hand.getAmount() - 1);
            } else {
                hand = null;
            }
            equipper.setItemInHand(hand);
            set.setAmount(1);
        }
        this.getTrait(Equipment.class).set(0, set);
    }

    public Enderman getBukkitEntity() {
        return (Enderman)this.getHandle().getBukkitEntity();
    }

    public static class EntityEndermanNPC
    extends EntityEnderman
    implements NPCHolder {
        private final CitizensNPC npc;
        private boolean pushable = false;

        public EntityEndermanNPC(World world) {
            this(world, null);
        }

        public EntityEndermanNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.goalSelector = new PathfinderGoalSelector();
                this.targetSelector = new PathfinderGoalSelector();
            }
        }

        public void b_(double x, double y, double z) {
            if (this.npc == null || this.pushable) {
                super.b_(x, y, z);
            }
        }

        public void d_() {
            if (this.npc == null) {
                super.d_();
            }
        }

        public void e() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.e();
            }
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        @Override
        public boolean isPushable() {
            return this.pushable;
        }

        @Override
        public void setPushable(boolean pushable) {
            this.pushable = pushable;
        }
    }
}

