/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.event.NPCCollisionEvent;
import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.minecraft.server.Entity;
import net.minecraft.server.Packet;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class Util {
    private static final Map<Class<?>, Class<?>> primitiveClassMap = Maps.newHashMap();

    private Util() {
    }

    public static void callCollisionEvent(NPC npc, Entity entity) {
        if (NPCCollisionEvent.getHandlerList().getRegisteredListeners().length > 0) {
            Bukkit.getPluginManager().callEvent((Event)new NPCCollisionEvent(npc, entity.getBukkitEntity()));
        }
    }

    public static NPCPushEvent callPushEvent(NPC npc, Vector vector) {
        NPCPushEvent event = new NPCPushEvent(npc, vector);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static <T> T createInstance(Class<? extends T> clazz, Object ... params) {
        Validate.notNull((Object)params);
        Validate.noNullElements((Object[])params);
        try {
            if (params.length == 0) {
                return clazz.newInstance();
            }
            return Util.createInstance0(clazz, params);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <T> T createInstance0(Class<? extends T> clazz, Object[] params) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<?>[] constructors = clazz.getConstructors();
        Arrays.sort(constructors, new Comparator<Constructor<?>>(){

            @Override
            public int compare(Constructor<?> o1, Constructor<?> o2) {
                return o2.getParameterTypes().length - o1.getParameterTypes().length;
            }
        });
        block0: for (Constructor<?> constructor : constructors) {
            Object[] types = constructor.getParameterTypes();
            if (Sets.newHashSet((Object[])types).size() != types.length) continue;
            if (types.length == 0) {
                return clazz.newInstance();
            }
            Object[] rebuild = new Object[types.length];
            for (Object param : params) {
                for (int i = 0; i < types.length; ++i) {
                    if (param.getClass() != types[i] && primitiveClassMap.get(param.getClass()) != types[i] && !Util.searchInterfaces(param.getClass(), types[i])) continue;
                    rebuild[i] = param;
                }
            }
            for (Object constructorParam : rebuild) {
                if (constructorParam == null) continue block0;
            }
            return (T)constructor.newInstance(rebuild);
        }
        return null;
    }

    public static boolean isSettingFulfilled(Player player, Settings.Setting setting) {
        String parts = setting.asString();
        if (parts.contains("*")) {
            return true;
        }
        for (String part : Splitter.on((char)',').split((CharSequence)parts)) {
            if (Material.matchMaterial((String)part) != player.getItemInHand().getType()) continue;
            return true;
        }
        return false;
    }

    public static EntityType matchEntityType(String toMatch) {
        EntityType type = EntityType.fromName((String)toMatch);
        if (type != null) {
            return type;
        }
        for (EntityType check : EntityType.values()) {
            if (!check.name().matches(toMatch) && !check.name().replace('_', '-').equals(toMatch)) continue;
            type = check;
            break;
        }
        return type;
    }

    private static boolean searchInterfaces(Class<?> class1, Class<?> class2) {
        for (Class<?> test : class1.getInterfaces()) {
            if (test != class2) continue;
            return true;
        }
        return false;
    }

    public static void sendPacketNearby(Location location, Packet packet, double radius) {
        radius *= radius;
        World world = location.getWorld();
        for (Player ply : Bukkit.getServer().getOnlinePlayers()) {
            if (ply == null || world != ply.getWorld() || location.distanceSquared(ply.getLocation()) > radius) continue;
            ((CraftPlayer)ply).getHandle().netServerHandler.sendPacket(packet);
        }
    }

    public static void sendToOnline(Packet ... packets) {
        Validate.notNull((Object)packets, (String)"packets cannot be null");
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player == null || !player.isOnline()) continue;
            for (Packet packet : packets) {
                ((CraftPlayer)player).getHandle().netServerHandler.sendPacket(packet);
            }
        }
    }

    static {
        primitiveClassMap.put(Boolean.class, Boolean.TYPE);
        primitiveClassMap.put(Byte.class, Byte.TYPE);
        primitiveClassMap.put(Short.class, Short.TYPE);
        primitiveClassMap.put(Character.class, Character.TYPE);
        primitiveClassMap.put(Integer.class, Integer.TYPE);
        primitiveClassMap.put(Long.class, Long.TYPE);
        primitiveClassMap.put(Float.class, Float.TYPE);
        primitiveClassMap.put(Double.class, Double.TYPE);
        primitiveClassMap.put(Boolean.TYPE, Boolean.class);
        primitiveClassMap.put(Byte.TYPE, Byte.class);
        primitiveClassMap.put(Short.TYPE, Short.class);
        primitiveClassMap.put(Character.TYPE, Character.class);
        primitiveClassMap.put(Integer.TYPE, Integer.class);
        primitiveClassMap.put(Long.TYPE, Long.class);
        primitiveClassMap.put(Float.TYPE, Float.class);
        primitiveClassMap.put(Double.TYPE, Double.class);
    }
}

