/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R3.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftGiant;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Giant;

public class GiantController
extends MobEntityController {
    public GiantController() {
        super(EntityGiantNPC.class, EntityTypes.ae);
    }

    public Giant getBukkitEntity() {
        return (Giant)super.getBukkitEntity();
    }

    public static class EntityGiantNPC
    extends EntityGiantZombie
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityGiantNPC(EntityTypes<? extends EntityGiantZombie> types, World level) {
            this(types, level, null);
        }

        public EntityGiantNPC(EntityTypes<? extends EntityGiantZombie> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
        }

        protected boolean o(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.o(entity);
        }

        public boolean a(float f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void dH() {
            if (this.npc == null) {
                super.dH();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void a(WorldServer level) {
            super.a(level);
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                this.npc.update();
            }
        }

        protected SoundEffect u() {
            return NMSImpl.getSoundEffect(this.npc, super.u(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new GiantNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect o_() {
            return NMSImpl.getSoundEffect(this.npc, super.o_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect e(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fj() {
            return NMS.getJumpPower(this.npc, super.fj());
        }

        public int cE() {
            return NMS.getFallDistance(this.npc, super.cE());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction n_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.n_();
        }

        public boolean P_() {
            return NMSImpl.isLeashed(this.npc, () -> super.P_(), (EntityInsentient)this);
        }

        public boolean bI() {
            return this.npc == null ? super.bI() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void p(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB(this.npc, super.c(vec3));
        }

        public boolean q_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.q_();
            }
            return false;
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void m_() {
            if (this.npc == null) {
                super.m_();
            } else {
                NMSImpl.setSize((net.minecraft.world.entity.Entity)this, this.ak);
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void a_(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a_(vec3d);
            } else {
                NMSImpl.moveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dy().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }
    }

    public static class GiantNPC
    extends CraftGiant
    implements ForwardingNPCHolder {
        public GiantNPC(EntityGiantNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityGiantZombie)entity);
        }
    }
}

