/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.api.ai.AttackStrategy;
import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.PathStrategy;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.npc.ai.AStarNavigationStrategy;
import net.citizensnpcs.npc.ai.FlyingAStarNavigationStrategy;
import net.citizensnpcs.npc.ai.StraightLineNavigationStrategy;
import net.citizensnpcs.util.NMS;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class MCTargetStrategy
implements PathStrategy,
EntityTarget {
    private final boolean aggro;
    private int attackTicks;
    private CancelReason cancelReason;
    private final Entity handle;
    private final NPC npc;
    private final NavigatorParameters parameters;
    private final Entity target;
    private TargetNavigator targetNavigator;
    private int updateCounter = -1;

    public MCTargetStrategy(NPC npc, Entity target, boolean aggro, NavigatorParameters params) {
        this.npc = npc;
        this.parameters = params;
        this.handle = npc.getEntity();
        this.target = target;
        TargetNavigator nms = NMS.getTargetNavigator(npc.getEntity(), target, params);
        this.targetNavigator = nms != null && !params.useNewPathfinder() ? nms : new AStarTargeter();
        this.aggro = aggro;
    }

    private boolean canAttack() {
        BoundingBox handleBB = NMS.getBoundingBox(this.handle);
        BoundingBox targetBB = NMS.getBoundingBox(this.target);
        return this.attackTicks <= 0 && handleBB.maxY > targetBB.minY && handleBB.minY < targetBB.maxY && this.distance() <= this.parameters.attackRange() && ((LivingEntity)this.handle).hasLineOfSight(this.target);
    }

    @Override
    public void clearCancelReason() {
        this.cancelReason = null;
    }

    private double distance() {
        return this.handle.getLocation().distance(this.target.getLocation());
    }

    @Override
    public CancelReason getCancelReason() {
        return this.cancelReason;
    }

    @Override
    public Location getCurrentDestination() {
        return this.targetNavigator.getCurrentDestination();
    }

    @Override
    public Iterable<Vector> getPath() {
        return this.targetNavigator.getPath();
    }

    @Override
    public Entity getTarget() {
        return this.target;
    }

    @Override
    public Location getTargetAsLocation() {
        return this.getTarget().getLocation();
    }

    @Override
    public TargetType getTargetType() {
        return TargetType.ENTITY;
    }

    @Override
    public boolean isAggressive() {
        return this.aggro;
    }

    @Override
    public void stop() {
        this.targetNavigator.stop();
    }

    public String toString() {
        return "MCTargetStrategy [target=" + this.target + "]";
    }

    @Override
    public boolean update() {
        if (this.target == null || !this.target.isValid()) {
            this.cancelReason = CancelReason.TARGET_DIED;
            return true;
        }
        if (this.target.getWorld() != this.handle.getWorld()) {
            this.cancelReason = CancelReason.TARGET_MOVED_WORLD;
            return true;
        }
        if (this.cancelReason != null) {
            return true;
        }
        if (this.parameters.straightLineTargetingDistance() > 0.0f && !(this.targetNavigator instanceof StraightLineTargeter)) {
            this.targetNavigator = new StraightLineTargeter(this.targetNavigator);
        }
        if (!this.aggro && this.distance() <= this.parameters.distanceMargin()) {
            this.stop();
            return false;
        }
        if (this.updateCounter == -1 || this.updateCounter++ > this.parameters.updatePathRate()) {
            this.targetNavigator.setPath();
            this.updateCounter = 0;
        }
        this.targetNavigator.update();
        NMS.look(this.handle, this.target);
        if (this.aggro && this.canAttack()) {
            AttackStrategy strategy = this.parameters.attackStrategy();
            if (strategy != null && !strategy.handle((LivingEntity)this.handle, (LivingEntity)this.getTarget()) && strategy != this.parameters.defaultAttackStrategy()) {
                this.parameters.defaultAttackStrategy().handle((LivingEntity)this.handle, (LivingEntity)this.getTarget());
            }
            this.attackTicks = this.parameters.attackDelayTicks();
        }
        if (this.attackTicks > 0) {
            --this.attackTicks;
        }
        return false;
    }

    public static interface TargetNavigator {
        public Location getCurrentDestination();

        public Iterable<Vector> getPath();

        public void setPath();

        public void stop();

        public void update();
    }

    private class AStarTargeter
    implements TargetNavigator {
        private int failureTimes = 0;
        private PathStrategy strategy;

        private AStarTargeter() {
        }

        @Override
        public Location getCurrentDestination() {
            if (this.strategy == null) {
                return null;
            }
            return this.strategy.getCurrentDestination();
        }

        @Override
        public Iterable<Vector> getPath() {
            return this.strategy.getPath();
        }

        @Override
        public void setPath() {
            this.setStrategy();
            this.strategy.update();
            CancelReason subReason = this.strategy.getCancelReason();
            if (subReason == CancelReason.STUCK) {
                if (this.failureTimes++ > 10) {
                    MCTargetStrategy.this.cancelReason = this.strategy.getCancelReason();
                }
            } else {
                this.failureTimes = 0;
                MCTargetStrategy.this.cancelReason = this.strategy.getCancelReason();
            }
        }

        private void setStrategy() {
            Location location = MCTargetStrategy.this.parameters.entityTargetLocationMapper().apply(MCTargetStrategy.this.target);
            if (location == null) {
                throw new IllegalStateException("mapper should not return null");
            }
            if (!MCTargetStrategy.this.npc.isFlyable()) {
                Block block = location.getBlock();
                while (!MinecraftBlockExaminer.canStandOn(block.getRelative(BlockFace.DOWN))) {
                    if ((block = block.getRelative(BlockFace.DOWN)).getY() > 0) continue;
                    block = location.getBlock();
                    break;
                }
                location = block.getLocation();
            }
            if (this.strategy != null) {
                this.strategy.stop();
            }
            this.strategy = MCTargetStrategy.this.npc.isFlyable() ? new FlyingAStarNavigationStrategy(MCTargetStrategy.this.npc, location, MCTargetStrategy.this.parameters) : new AStarNavigationStrategy(MCTargetStrategy.this.npc, location, MCTargetStrategy.this.parameters);
        }

        @Override
        public void stop() {
            if (this.strategy != null) {
                this.strategy.stop();
            }
        }

        @Override
        public void update() {
            this.strategy.update();
        }
    }

    private class StraightLineTargeter
    implements TargetNavigator {
        private PathStrategy active;
        private final TargetNavigator fallback;

        public StraightLineTargeter(TargetNavigator navigator) {
            this.fallback = navigator;
        }

        @Override
        public Location getCurrentDestination() {
            return this.active == null ? null : this.active.getCurrentDestination();
        }

        @Override
        public Iterable<Vector> getPath() {
            return this.active != null ? this.active.getPath() : this.fallback.getPath();
        }

        @Override
        public void setPath() {
            Location location = MCTargetStrategy.this.parameters.entityTargetLocationMapper().apply(MCTargetStrategy.this.target);
            if (location == null) {
                throw new IllegalStateException("mapper should not return null");
            }
            if (MCTargetStrategy.this.parameters.straightLineTargetingDistance() > 0.0f && MCTargetStrategy.this.npc.getStoredLocation().distance(location) <= (double)MCTargetStrategy.this.parameters.straightLineTargetingDistance()) {
                this.active = new StraightLineNavigationStrategy(MCTargetStrategy.this.npc, MCTargetStrategy.this.target, MCTargetStrategy.this.parameters);
                return;
            }
            this.active = null;
            this.fallback.setPath();
        }

        @Override
        public void stop() {
            if (this.active != null) {
                this.active.stop();
            }
            this.fallback.stop();
        }

        @Override
        public void update() {
            if (this.active != null) {
                this.active.update();
            } else {
                this.fallback.update();
            }
        }
    }
}

