/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class SkinUpdateTracker {
    private final Map<SkinnableEntity, Void> navigating = new WeakHashMap<SkinnableEntity, Void>(25);
    private final Map<UUID, PlayerTracker> playerTrackers = new HashMap<UUID, PlayerTracker>(Math.max(128, Math.min(1024, Bukkit.getMaxPlayers() / 2)));
    private final NPCNavigationUpdater updater = new NPCNavigationUpdater();
    private static float FIELD_OF_VIEW = 70.0f;
    private static int MOVEMENT_SKIN_UPDATE_DISTANCE = 25;

    public SkinUpdateTracker() {
        this.updater.runTaskTimer(CitizensAPI.getPlugin(), 1L, 1L);
        new NPCNavigationTracker().runTaskTimer(CitizensAPI.getPlugin(), 3L, 7L);
    }

    private boolean canSee(Player player, SkinnableEntity skinnable, boolean checkFov) {
        Location skinLoc;
        Player entity = skinnable.getBukkitEntity();
        if (entity == null || !player.canSee(entity) || !player.getWorld().equals((Object)entity.getWorld())) {
            return false;
        }
        Location playerLoc = player.getLocation();
        if (playerLoc.distance(skinLoc = entity.getLocation()) > (double)skinnable.getNPC().data().get(NPC.Metadata.TRACKING_RANGE, Integer.valueOf(Settings.Setting.NPC_SKIN_VIEW_DISTANCE.asInt())).intValue()) {
            return false;
        }
        if (checkFov) {
            double deltaX = skinLoc.getX() - playerLoc.getX();
            double deltaZ = skinLoc.getZ() - playerLoc.getZ();
            double angle = Math.atan2(deltaX, deltaZ);
            float skinYaw = Util.clamp(-((float)Math.toDegrees(angle)));
            float playerYaw = Util.clamp(playerLoc.getYaw());
            float upperBound = Util.clamp(playerYaw + FIELD_OF_VIEW);
            float lowerBound = Util.clamp(playerYaw - FIELD_OF_VIEW);
            if ((double)upperBound == -180.0 && playerYaw > 0.0f) {
                upperBound = 0.0f;
            }
            boolean hasMoved = playerYaw - 90.0f < -180.0f || playerYaw + 90.0f > 180.0f ? skinYaw > lowerBound && skinYaw < upperBound : skinYaw < lowerBound || skinYaw > upperBound;
            return hasMoved;
        }
        return true;
    }

    private Iterable<NPC> getAllNPCs() {
        return Iterables.filter((Iterable)Iterables.concat(CitizensAPI.getNPCRegistries()), Objects::nonNull);
    }

    private List<SkinnableEntity> getNearbyNPCs(Player player, boolean reset, boolean checkFov) {
        ArrayList<SkinnableEntity> results = new ArrayList<SkinnableEntity>();
        PlayerTracker tracker = this.getTracker(player, reset);
        for (NPC npc : this.getAllNPCs()) {
            SkinnableEntity skinnable = this.getSkinnable(npc);
            if (skinnable == null || checkFov && tracker.fovVisibleSkins.contains(skinnable) || !this.canSee(player, skinnable, checkFov)) continue;
            results.add(skinnable);
        }
        return results;
    }

    private void getNewVisibleNavigating(Player player, Collection<SkinnableEntity> output) {
        PlayerTracker tracker = this.getTracker(player, false);
        for (SkinnableEntity skinnable : this.navigating.keySet()) {
            if (tracker.fovVisibleSkins.contains(skinnable) || !this.canSee(player, skinnable, true)) continue;
            output.add(skinnable);
        }
    }

    @Nullable
    private SkinnableEntity getSkinnable(NPC npc) {
        Entity entity = npc.getEntity();
        if (entity == null) {
            return null;
        }
        return entity instanceof SkinnableEntity ? (SkinnableEntity)entity : null;
    }

    private PlayerTracker getTracker(Player player, boolean reset) {
        PlayerTracker tracker = this.playerTrackers.get(player.getUniqueId());
        if (tracker == null) {
            tracker = new PlayerTracker(player);
            this.playerTrackers.put(player.getUniqueId(), tracker);
        } else if (reset) {
            tracker.hardReset(player);
        }
        return tracker;
    }

    public void onNPCDespawn(NPC npc) {
        Objects.requireNonNull(npc);
        this.playerTrackers.remove(npc.getUniqueId());
        SkinnableEntity skinnable = this.getSkinnable(npc);
        if (skinnable == null) {
            return;
        }
        this.navigating.remove(skinnable);
        for (PlayerTracker tracker : this.playerTrackers.values()) {
            tracker.fovVisibleSkins.remove(skinnable);
        }
    }

    public void onNPCNavigationBegin(NPC npc) {
        Objects.requireNonNull(npc);
        SkinnableEntity skinnable = this.getSkinnable(npc);
        if (skinnable == null) {
            return;
        }
        this.navigating.put(skinnable, null);
    }

    public void onNPCNavigationComplete(NPC npc) {
        Objects.requireNonNull(npc);
        SkinnableEntity skinnable = this.getSkinnable(npc);
        if (skinnable == null) {
            return;
        }
        this.navigating.remove(skinnable);
    }

    public void onNPCSpawn(NPC npc) {
        Objects.requireNonNull(npc);
        SkinnableEntity skinnable = this.getSkinnable(npc);
        if (skinnable == null) {
            return;
        }
        this.resetNearbyPlayers(skinnable);
    }

    public void onPlayerMove(Player player) {
        Objects.requireNonNull(player);
        PlayerTracker updateTracker = this.playerTrackers.get(player.getUniqueId());
        if (updateTracker == null || !updateTracker.shouldUpdate(player)) {
            return;
        }
        this.updatePlayer(player, 10L, false);
    }

    public void removePlayer(UUID playerId) {
        Objects.requireNonNull(playerId);
        this.playerTrackers.remove(playerId);
    }

    public void reset() {
        this.navigating.clear();
        this.playerTrackers.clear();
    }

    private void resetNearbyPlayers(SkinnableEntity skinnable) {
        Player entity = skinnable.getBukkitEntity();
        if (entity == null || !entity.isValid()) {
            return;
        }
        double viewDistance = skinnable.getNPC().data().get(NPC.Metadata.TRACKING_RANGE, Integer.valueOf(Settings.Setting.NPC_SKIN_VIEW_DISTANCE.asInt())).intValue();
        Location location = entity.getLocation();
        List players = entity.getWorld().getPlayers();
        for (Player player : players) {
            PlayerTracker tracker;
            Location ploc;
            if (player.hasMetadata("NPC") || (ploc = player.getLocation()).getWorld() != location.getWorld() || ploc.distance(location) > viewDistance || (tracker = this.playerTrackers.get(player.getUniqueId())) == null) continue;
            tracker.hardReset(player);
        }
    }

    public void updatePlayer(final Player player, final long delay, final boolean reset) {
        if (player.hasMetadata("NPC")) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                List visible = SkinUpdateTracker.this.getNearbyNPCs(player, reset, false);
                for (SkinnableEntity skinnable : visible) {
                    if (Messaging.isDebugging()) {
                        Messaging.debug("Sending skin from", skinnable.getBukkitEntity(), "to", player, "(" + delay + "t delay, reset", reset + ")");
                    }
                    skinnable.getSkinTracker().updateViewer(player);
                }
            }
        }.runTaskLater(CitizensAPI.getPlugin(), delay);
    }

    private static class NPCNavigationUpdater
    extends BukkitRunnable {
        Queue<UpdateInfo> queue = new ArrayDeque<UpdateInfo>(20);

        private NPCNavigationUpdater() {
        }

        public void run() {
            while (!this.queue.isEmpty()) {
                UpdateInfo info = this.queue.remove();
                info.entity.getSkinTracker().updateViewer(info.player);
            }
        }
    }

    private static class PlayerTracker {
        Set<SkinnableEntity> fovVisibleSkins = new HashSet<SkinnableEntity>(10);
        boolean hasMoved;
        Location location = new Location(null, 0.0, 0.0, 0.0);
        float lowerBound;
        int rotationCount;
        float startYaw;
        float upperBound;

        PlayerTracker(Player player) {
            this.hardReset(player);
        }

        void hardReset(Player player) {
            this.hasMoved = false;
            this.rotationCount = 0;
            this.startYaw = 0.0f;
            this.upperBound = 0.0f;
            this.lowerBound = 0.0f;
            this.fovVisibleSkins.clear();
            this.reset(player);
        }

        void reset(Player player) {
            player.getLocation(this.location);
            if (this.rotationCount < 3) {
                float yaw;
                float rotationDegrees = Settings.Setting.NPC_SKIN_ROTATION_UPDATE_DEGREES.asFloat();
                this.startYaw = yaw = Util.clamp(this.location.getYaw());
                this.upperBound = Util.clamp(yaw + rotationDegrees);
                this.lowerBound = Util.clamp(yaw - rotationDegrees);
                if ((double)this.upperBound == -180.0 && this.startYaw > 0.0f) {
                    this.upperBound = 0.0f;
                }
            }
        }

        boolean shouldUpdate(Player player) {
            Location currentLoc = player.getLocation();
            if (!currentLoc.getWorld().equals((Object)this.location.getWorld())) {
                this.hardReset(player);
                return true;
            }
            if (!this.hasMoved) {
                this.hasMoved = true;
                return true;
            }
            if (this.rotationCount < 3) {
                boolean hasRotated;
                float yaw = Util.clamp(currentLoc.getYaw());
                if (this.startYaw - 90.0f < -180.0f || this.startYaw + 90.0f > 180.0f) {
                    hasRotated = yaw > this.lowerBound && yaw < this.upperBound;
                } else {
                    boolean bl = hasRotated = yaw < this.lowerBound || yaw > this.upperBound;
                }
                if (hasRotated) {
                    ++this.rotationCount;
                    this.reset(player);
                    return true;
                }
            }
            if (currentLoc.distance(this.location) > (double)MOVEMENT_SKIN_UPDATE_DISTANCE) {
                this.reset(player);
                return true;
            }
            return false;
        }
    }

    private class NPCNavigationTracker
    extends BukkitRunnable {
        private NPCNavigationTracker() {
        }

        public void run() {
            if (SkinUpdateTracker.this.navigating.isEmpty() || SkinUpdateTracker.this.playerTrackers.isEmpty()) {
                return;
            }
            ArrayList nearby = new ArrayList(10);
            HashSet seen = Sets.newHashSet();
            for (Player player : Bukkit.getOnlinePlayers()) {
                seen.add(player.getUniqueId());
                if (player.hasMetadata("NPC")) continue;
                SkinUpdateTracker.this.getNewVisibleNavigating(player, nearby);
                for (SkinnableEntity skinnable : nearby) {
                    PlayerTracker tracker = SkinUpdateTracker.this.getTracker(player, false);
                    tracker.fovVisibleSkins.add(skinnable);
                    ((SkinUpdateTracker)SkinUpdateTracker.this).updater.queue.offer(new UpdateInfo(player, skinnable));
                }
                nearby.clear();
            }
            SkinUpdateTracker.this.playerTrackers.keySet().removeIf(uuid -> !seen.contains(uuid));
        }
    }

    private static class UpdateInfo {
        SkinnableEntity entity;
        Player player;

        UpdateInfo(Player player, SkinnableEntity entity) {
            this.player = player;
            this.entity = entity;
        }
    }
}

