/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin.profile;

import com.mojang.authlib.GameProfile;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import javax.annotation.Nullable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.npc.skin.profile.ProfileFetchHandler;
import net.citizensnpcs.npc.skin.profile.ProfileFetchResult;
import org.bukkit.Bukkit;

public class ProfileRequest {
    private Deque<ProfileFetchHandler> handlers;
    private final String playerName;
    private GameProfile profile;
    private volatile ProfileFetchResult result = ProfileFetchResult.PENDING;

    public ProfileRequest(String playerName, ProfileFetchHandler handler) {
        Objects.requireNonNull(playerName);
        this.playerName = playerName;
        if (handler != null) {
            this.addHandler(handler);
        }
    }

    public void addHandler(ProfileFetchHandler handler) {
        Objects.requireNonNull(handler);
        if (this.result != ProfileFetchResult.PENDING) {
            handler.onResult(this);
            return;
        }
        if (this.handlers == null) {
            this.handlers = new ArrayDeque<ProfileFetchHandler>();
        }
        this.handlers.addLast(handler);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    @Nullable
    public GameProfile getProfile() {
        return this.profile;
    }

    public ProfileFetchResult getResult() {
        return this.result;
    }

    void setResult(@Nullable GameProfile profile, ProfileFetchResult result) {
        if (!CitizensAPI.hasImplementation()) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            this.profile = profile;
            this.result = result;
            if (this.handlers == null) {
                return;
            }
            while (!this.handlers.isEmpty()) {
                this.handlers.removeFirst().onResult(this);
            }
            this.handlers = null;
        });
    }
}

