/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.gui.CitizensInventoryClickEvent;
import net.citizensnpcs.api.gui.ClickHandler;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenu;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuPattern;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuPattern;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitEventHandler;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.trait.shop.CommandAction;
import net.citizensnpcs.trait.shop.ExperienceAction;
import net.citizensnpcs.trait.shop.ItemAction;
import net.citizensnpcs.trait.shop.MoneyAction;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.trait.shop.OpenShopAction;
import net.citizensnpcs.trait.shop.PermissionAction;
import net.citizensnpcs.trait.shop.StoredShops;
import net.citizensnpcs.util.InventoryMultiplexer;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.ItemMeta;

@TraitName(value="shop")
public class ShopTrait
extends Trait {
    @Persist
    private String rightClickShop;
    private StoredShops shops;
    @Persist(reify=true)
    private final NPCShopStorage storage = new NPCShopStorage();

    public ShopTrait() {
        super("shop");
    }

    public ShopTrait(StoredShops shops) {
        this();
        this.shops = shops;
    }

    public NPCShop getDefaultShop() {
        return this.shops.npcShops.computeIfAbsent(this.npc.getUniqueId().toString(), NPCShop::new);
    }

    public NPCShop getShop(String name) {
        return this.shops.globalShops.computeIfAbsent(name, NPCShop::new);
    }

    @Override
    public void onRemove() {
        this.shops.deleteShop(this.getDefaultShop());
    }

    @TraitEventHandler(value=@EventHandler)
    public void onRightClick(NPCRightClickEvent event) {
        if (this.rightClickShop == null || this.rightClickShop.isEmpty()) {
            return;
        }
        Player player = event.getClicker();
        event.setDelayedCancellation(true);
        String globalViewPermission = Settings.Setting.SHOP_GLOBAL_VIEW_PERMISSION.asString();
        if (!globalViewPermission.isEmpty() && !player.hasPermission(globalViewPermission)) {
            return;
        }
        NPCShop shop = this.shops.globalShops.getOrDefault(this.rightClickShop, this.getDefaultShop());
        shop.display(this.storage, player);
    }

    public void setDefaultShop(NPCShop shop) {
        this.shops.npcShops.put(this.npc.getUniqueId().toString(), shop);
    }

    static {
        NPCShopAction.register(ItemAction.class, "items", new ItemAction.ItemActionGUI());
        NPCShopAction.register(PermissionAction.class, "permissions", new PermissionAction.PermissionActionGUI());
        NPCShopAction.register(MoneyAction.class, "money", new MoneyAction.MoneyActionGUI());
        NPCShopAction.register(CommandAction.class, "command", new CommandAction.CommandActionGUI());
        NPCShopAction.register(ExperienceAction.class, "experience", new ExperienceAction.ExperienceActionGUI());
        NPCShopAction.register(OpenShopAction.class, "open_shop", new OpenShopAction.OpenShopActionGUI());
    }

    public static class NPCShopStorage {
        @Persist
        private double balance;
        @Persist
        private List<ItemStack> inventory = Lists.newArrayList();
        @Persist
        private int inventorySizeLimit = -1;
        @Persist
        private boolean unlimited = true;

        public boolean canAdd(int n) {
            return this.inventorySizeLimit == -1 || this.inventory.size() + n < this.inventorySizeLimit;
        }

        public InventoryMenuPage createInventoryViewer(HumanEntity whoClicked) {
            return new InventoryViewer(this);
        }

        public double getBalance() {
            return this.balance;
        }

        public ItemStack[] getInventory() {
            return this.inventory.toArray(new ItemStack[this.inventory.size()]);
        }

        public int getInventorySizeLimit() {
            return this.inventorySizeLimit;
        }

        public boolean isUnlimited() {
            return this.unlimited;
        }

        public void setBalance(double amount) {
            if (this.isUnlimited()) {
                return;
            }
            this.balance = amount;
        }

        public void setInventory(List<ItemStack> items) {
            this.inventory = items;
        }

        public void setInventorySizeLimit(int limit) {
            this.inventorySizeLimit = limit;
        }

        public void setUnlimited(boolean res) {
            this.unlimited = res;
        }

        public void transact(Consumer<ItemStack[]> action) {
            this.transact(action, 0);
        }

        public void transact(Consumer<ItemStack[]> action, int additional) {
            if (this.isUnlimited()) {
                return;
            }
            ItemStack[] items = this.inventory.toArray(new ItemStack[this.inventory.size() + additional]);
            action.accept(items);
            this.inventory = Arrays.stream(items).filter(i -> i != null && i.getAmount() > 0 && i.getType() != Material.AIR).collect(Collectors.toList());
        }

        @Menu(title="Item storage", dimensions={4, 9})
        public static class InventoryViewer
        extends InventoryMenuPage {
            private MenuContext ctx;
            private NPCShopStorage storage;

            public InventoryViewer() {
            }

            public InventoryViewer(NPCShopStorage storage) {
                this.storage = storage;
            }

            @Override
            public void initialise(MenuContext ctx) {
                this.ctx = ctx;
                for (int i = 0; i < 27; ++i) {
                    InventoryMenuSlot slot = ctx.getSlot(i);
                    slot.clear();
                    slot.setClickHandler(evt -> evt.setCancelled(false));
                    if (i >= this.storage.inventory.size()) break;
                    slot.setItemStack(((ItemStack)this.storage.inventory.get(i)).clone());
                }
                ctx.getSlot(28).setItemStack(new ItemStack(Material.BEACON), "Unlimited<br>", this.storage.isUnlimited() ? ChatColor.GREEN + "On" : ChatColor.RED + "Off");
                ctx.getSlot(28).addClickHandler(InputMenus.toggler(res -> this.storage.setUnlimited((boolean)res), this.storage.isUnlimited()));
                ctx.getSlot(29).setItemStack(new ItemStack(Util.getFallbackMaterial("COMPARATOR", "REDSTONE_COMPARATOR")), "Inventory size limit", this.storage.getInventorySizeLimit() == -1 ? ChatColor.GREEN + "Unlimited" : ChatColor.YELLOW + "" + this.storage.getInventorySizeLimit());
                ctx.getSlot(29).addClickHandler(evt -> ctx.getMenu().transition(InputMenus.filteredStringSetter(() -> Integer.toString(this.storage.getInventorySizeLimit()), s -> {
                    if (Ints.tryParse((String)s) == null) {
                        return false;
                    }
                    this.storage.setInventorySizeLimit(Ints.tryParse((String)s));
                    return true;
                })));
            }

            @Override
            public void onClose(HumanEntity player) {
                ArrayList items = Lists.newArrayList();
                for (int i = 0; i < 27; ++i) {
                    if (this.ctx.getSlot(i).getCurrentItem() == null) continue;
                    items.add(this.ctx.getSlot(i).getCurrentItem().clone());
                }
                this.storage.setInventory(items);
            }
        }
    }

    public static class NPCShop {
        @Persist(value="")
        private String name;
        @Persist(reify=true)
        private final List<NPCShopPage> pages = Lists.newArrayList();
        @Persist(reify=true)
        private NPCShopStorage storage;
        @Persist
        private String title;
        @Persist
        private ShopType type = ShopType.DEFAULT;
        @Persist
        private String viewPermission;

        private NPCShop() {
        }

        public NPCShop(String name) {
            this.name = name;
        }

        public boolean canEdit(NPC npc, Player sender) {
            return sender.hasPermission("citizens.admin") || sender.hasPermission("citizens.npc.shop.edit") || sender.hasPermission("citizens.npc.shop.edit." + this.getName()) || npc != null && npc.getOrAddTrait(Owner.class).isOwnedBy((CommandSender)sender);
        }

        public boolean canView(Player sender) {
            if (this.viewPermission != null && !sender.hasPermission(this.viewPermission)) {
                return false;
            }
            return Settings.Setting.SHOP_GLOBAL_VIEW_PERMISSION.asString().isEmpty() || sender.hasPermission(Settings.Setting.SHOP_GLOBAL_VIEW_PERMISSION.asString());
        }

        public void display(NPCShopStorage storage, Player sender) {
            if (!this.canView(sender)) {
                return;
            }
            if (this.pages.size() == 0) {
                Messaging.sendError((CommandSender)sender, "Empty shop");
                return;
            }
            if (this.type == ShopType.TRADER) {
                CitizensAPI.registerEvents(new NPCTraderShopViewer(this, storage, sender));
            } else {
                InventoryMenu.createSelfRegistered(new NPCShopViewer(this, storage, sender)).present((HumanEntity)sender);
            }
        }

        public void display(Player sender) {
            this.display(this.storage, sender);
        }

        public void displayEditor(ShopTrait trait, Player sender) {
            InventoryMenu.createSelfRegistered(new NPCShopSettings(trait, this)).present((HumanEntity)sender);
        }

        public String getName() {
            return this.name == null ? "" : this.name;
        }

        public NPCShopPage getOrCreatePage(int page) {
            while (this.pages.size() <= page) {
                this.pages.add(new NPCShopPage(page));
            }
            return this.pages.get(page);
        }

        public String getRequiredPermission() {
            return this.viewPermission;
        }

        public ShopType getShopType() {
            return this.type == null ? (this.type = ShopType.DEFAULT) : this.type;
        }

        public String getTitle() {
            return this.title == null ? "" : this.title;
        }

        public void removePage(int index) {
            for (int i = 0; i < this.pages.size(); ++i) {
                if (this.pages.get(i).index == index) {
                    this.pages.remove(i--);
                    index = -1;
                    continue;
                }
                if (index != -1) continue;
                this.pages.get(i).index--;
            }
        }

        public void setPermission(String permission) {
            this.viewPermission = permission;
            if (this.viewPermission != null && this.viewPermission.isEmpty()) {
                this.viewPermission = null;
            }
        }

        public void setShopType(ShopType type) {
            this.type = type;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }

    public static enum ShopType {
        CHEST_1X9(9, 7, 6, 8),
        CHEST_2X9(18),
        CHEST_3X9(27),
        CHEST_4X9(36),
        DEFAULT(45),
        TRADER(45);

        private final int editSlotIndex;
        private final int inventorySize;
        private final int nextSlotIndex;
        private final int prevSlotIndex;

        private ShopType(int inventorySize) {
            this(inventorySize, inventorySize - 9 + 3, inventorySize - 9 + 4, inventorySize - 9 + 5);
        }

        private ShopType(int inventorySize, int prevSlotIndex, int editSlotIndex, int nextSlotIndex) {
            this.inventorySize = inventorySize;
            this.prevSlotIndex = prevSlotIndex;
            this.editSlotIndex = editSlotIndex;
            this.nextSlotIndex = nextSlotIndex;
        }
    }

    public static class NPCTraderShopViewer
    implements Listener {
        private int lastClickedTrade = -1;
        private final Player player;
        private int selectedTrade = -1;
        private final NPCShop shop;
        private final NPCShopStorage storage;
        private final Map<Integer, NPCShopItem> trades;
        private final Object view;

        public NPCTraderShopViewer(NPCShop shop, NPCShopStorage storage, Player player) {
            this.shop = shop;
            this.player = player;
            this.storage = storage;
            HashMap tradesMap = Maps.newHashMap();
            Merchant merchant = Bukkit.createMerchant((String)shop.getTitle());
            ArrayList recipes = Lists.newArrayList();
            for (NPCShopPage page : shop.pages) {
                for (NPCShopItem item : page.items.values()) {
                    ItemStack result = item.getDisplayItem(player);
                    if (result == null) continue;
                    MerchantRecipe recipe = new MerchantRecipe(result.clone(), 100000000);
                    block2: for (NPCShopAction action : item.cost) {
                        if (!(action instanceof ItemAction)) continue;
                        ItemAction ia = (ItemAction)action;
                        for (ItemStack stack : ia.items) {
                            stack = stack.clone();
                            if (ia.metaFilter.size() > 0) {
                                ItemMeta im = stack.getItemMeta();
                                for (NamespacedKey nk : Lists.newArrayList((Iterable)im.getPersistentDataContainer().getKeys())) {
                                    im.getPersistentDataContainer().remove(nk);
                                }
                                NMS.clearCustomNBT(im);
                                stack.setItemMeta(im);
                            }
                            recipe.addIngredient(stack);
                            if (recipe.getIngredients().size() != 2) continue;
                            continue block2;
                        }
                    }
                    if (recipe.getIngredients().size() == 0) continue;
                    tradesMap.put(recipes.size(), item);
                    recipes.add(recipe);
                }
            }
            merchant.setRecipes((List)recipes);
            this.trades = tradesMap;
            this.view = player.openMerchant(merchant, true);
        }

        @EventHandler
        public void onInventoryClick(InventoryClickEvent evt) {
            if (!evt.getView().equals(this.view) || evt.getSlotType() != InventoryType.SlotType.RESULT) {
                return;
            }
            evt.setCancelled(true);
            if (this.selectedTrade == -1) {
                return;
            }
            if (!this.trades.containsKey(this.selectedTrade)) {
                Messaging.severe("Invalid trade selection", this.selectedTrade, "from", evt.getWhoClicked());
                return;
            }
            if (!evt.getAction().name().contains("PICKUP") || evt.getCursor() != null && evt.getCursor().getType() != Material.AIR) {
                return;
            }
            Inventory syntheticInventory = Bukkit.createInventory(null, (int)9);
            syntheticInventory.setItem(0, evt.getClickedInventory().getItem(0));
            syntheticInventory.setItem(1, evt.getClickedInventory().getItem(1));
            InventoryMultiplexer multiplexer = new InventoryMultiplexer(new Inventory[]{this.player.getInventory(), syntheticInventory});
            this.trades.get(this.selectedTrade).onClick(this.shop, this.storage, this.player, multiplexer, evt.getClick().isShiftClick(), this.lastClickedTrade == this.selectedTrade);
            evt.getClickedInventory().setItem(0, syntheticInventory.getItem(0));
            evt.getClickedInventory().setItem(1, syntheticInventory.getItem(1));
            this.lastClickedTrade = this.selectedTrade;
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent evt) {
            if (!evt.getPlayer().equals((Object)this.player)) {
                return;
            }
            HandlerList.unregisterAll((Listener)this);
        }

        @EventHandler
        public void onTradeSelect(TradeSelectEvent evt) {
            if (!evt.getView().equals(this.view)) {
                return;
            }
            this.selectedTrade = evt.getIndex();
            this.lastClickedTrade = -1;
        }
    }

    @Menu(title="Shop", type=InventoryType.CHEST, dimensions={5, 9})
    public static class NPCShopViewer
    extends InventoryMenuPage {
        private MenuContext ctx;
        private int currentPage = 0;
        private NPCShopItem lastClickedItem;
        private final Player player;
        private final NPCShop shop;
        private final NPCShopStorage storage;

        public NPCShopViewer(NPCShop shop, NPCShopStorage storage, Player player) {
            this.shop = shop;
            this.player = player;
            this.storage = storage;
        }

        public void changePage(int newPage) {
            this.currentPage = newPage;
            NPCShopPage page = (NPCShopPage)this.shop.pages.get(this.currentPage);
            if (page.title != null && !page.title.isEmpty()) {
                Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> this.ctx.setTitle(Placeholders.replace(page.title, (OfflinePlayer)this.player)), 1L);
            }
            for (int i = 0; i < this.ctx.getInventory().getSize(); ++i) {
                this.ctx.getSlot(i).clear();
                NPCShopItem item = page.getItem(i);
                if (item == null) continue;
                this.ctx.getSlot(i).setItemStack(item.getDisplayItem(this.player));
                this.ctx.getSlot(i).setClickHandler(evt -> {
                    evt.setCancelled(true);
                    item.onClick(this.shop, this.storage, (Player)evt.getWhoClicked(), new InventoryMultiplexer(new Inventory[]{evt.getWhoClicked().getInventory()}), evt.isShiftClick(), this.lastClickedItem == item);
                    this.lastClickedItem = item;
                });
            }
            InventoryMenuSlot prev = this.ctx.getSlot(this.shop.getShopType().prevSlotIndex);
            InventoryMenuSlot next = this.ctx.getSlot(this.shop.getShopType().nextSlotIndex);
            if (this.currentPage > 0) {
                prev.clear();
                prev.setItemStack(page.getPreviousPageItem(this.player, this.shop.getShopType().prevSlotIndex), "Previous page (" + newPage + ")");
                prev.setClickHandler(evt -> {
                    evt.setCancelled(true);
                    this.changePage(this.currentPage - 1);
                });
            }
            if (this.currentPage + 1 < this.shop.pages.size()) {
                next.clear();
                next.setItemStack(page.getNextPageItem(this.player, this.shop.getShopType().nextSlotIndex), "Next page (" + (newPage + 1) + ")");
                next.setClickHandler(evt -> {
                    evt.setCancelled(true);
                    this.changePage(this.currentPage + 1);
                });
            }
        }

        @Override
        public Inventory createInventory(String title) {
            return Bukkit.createInventory(null, (int)this.shop.getShopType().inventorySize, (String)(this.shop.getTitle().isEmpty() ? "Shop" : Messaging.parseComponents(Placeholders.replace(this.shop.getTitle(), (OfflinePlayer)this.player))));
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.ctx = ctx;
            this.changePage(this.currentPage);
        }
    }

    @Menu(title="NPC Shop Editor", type=InventoryType.CHEST, dimensions={2, 9})
    public static class NPCShopSettings
    extends InventoryMenuPage {
        private MenuContext ctx;
        private final NPCShop shop;
        private final NPCShopStorage storage;
        private final ShopTrait trait;

        public NPCShopSettings(ShopTrait trait, NPCShop shop) {
            this.trait = trait;
            this.shop = shop;
            this.storage = trait.storage != null ? trait.storage : shop.storage;
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.ctx = ctx;
            ctx.getSlot(0).setDescription("<f>Edit permission required to view shop<br>" + this.shop.getRequiredPermission());
            ctx.getSlot(4).setDescription("<f>Edit shop title<br>" + this.shop.getTitle());
            if (this.trait != null) {
                ctx.getSlot(6).setDescription("<f>Show shop on right click<br>" + this.shop.getName().equals(this.trait.rightClickShop));
            }
            boolean economySupported = false;
            try {
                if (Bukkit.getServicesManager().getRegistration(Economy.class).getProvider() != null) {
                    economySupported = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (economySupported) {
                ctx.getSlot(12).setItemStack(new ItemStack(Material.EMERALD, 1));
                ctx.getSlot(12).setDescription("<f>Shop balance: " + this.storage.getBalance() + "<br>Click to deposit<br>Shift click to withdraw");
            }
        }

        @MenuSlot(slot={1, 3})
        public void onEditBalance(InventoryMenuSlot slot, final CitizensInventoryClickEvent event) {
            try {
                if (Bukkit.getServicesManager().getRegistration(Economy.class).getProvider() == null) {
                    return;
                }
            }
            catch (Throwable t) {
                return;
            }
            new Object(){
                {
                    Economy economy = (Economy)Bukkit.getServicesManager().getRegistration(Economy.class).getProvider();
                    double balance = economy.getBalance((OfflinePlayer)((Player)event.getWhoClicked()));
                    if (event.isShiftClick()) {
                        ctx.getMenu().transition(InputMenus.filteredStringSetter("Withdraw amount (max: " + storage.getBalance() + ")", () -> "", s -> {
                            Double amount = Doubles.tryParse((String)s);
                            if (amount == null) {
                                return false;
                            }
                            if (amount < 0.0 || amount > storage.getBalance()) {
                                return false;
                            }
                            EconomyResponse response = economy.depositPlayer((OfflinePlayer)((Player)event.getWhoClicked()), amount.doubleValue());
                            if (!response.transactionSuccess()) {
                                return false;
                            }
                            storage.setBalance(storage.getBalance() - amount);
                            return true;
                        }));
                    } else {
                        ctx.getMenu().transition(InputMenus.filteredStringSetter("Deposit amount (max: " + balance + ")", () -> "", s -> {
                            Double amount = Doubles.tryParse((String)s);
                            if (amount == null) {
                                return false;
                            }
                            if (amount < 0.0) {
                                return false;
                            }
                            EconomyResponse response = economy.withdrawPlayer((OfflinePlayer)((Player)event.getWhoClicked()), amount.doubleValue());
                            if (!response.transactionSuccess()) {
                                return false;
                            }
                            storage.setBalance(storage.getBalance() + amount);
                            return true;
                        }));
                    }
                }
            };
        }

        @MenuSlot(slot={0, 2}, material=Material.FEATHER, amount=1, title="<f>Edit shop items")
        public void onEditItems(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            this.ctx.getMenu().transition(new NPCShopContentsEditor(this.shop));
        }

        @MenuSlot(slot={0, 0}, compatMaterial={"OAK_SIGN", "SIGN"}, amount=1)
        public void onPermissionChange(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            this.ctx.getMenu().transition(InputMenus.stringSetter(this.shop::getRequiredPermission, this.shop::setPermission));
        }

        @MenuSlot(slot={0, 8}, material=Material.CHEST, amount=1, title="<f>Set shop type")
        public void onSetInventoryType(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            if (!event.getWhoClicked().hasPermission("citizens.admin") && !event.getWhoClicked().hasPermission("citizens.npc.shop.editor.set-shop-type")) {
                event.setCancelled(true);
                Messaging.sendTr((CommandSender)event.getWhoClicked(), "citizens.commands.requirements.missing-permission", new Object[0]);
                return;
            }
            this.ctx.getMenu().transition(InputMenus.picker("Set shop type", choice -> this.shop.setShopType((ShopType)((Object)((Object)choice.getValue()))), InputMenus.Choice.of(ShopType.DEFAULT, Material.CHEST, "Default (5x9 chest)", this.shop.getShopType() == ShopType.DEFAULT), InputMenus.Choice.of(ShopType.CHEST_4X9, Material.CHEST, "4x9 chest", this.shop.getShopType() == ShopType.CHEST_4X9), InputMenus.Choice.of(ShopType.CHEST_3X9, Material.CHEST, "3x9 chest", this.shop.getShopType() == ShopType.CHEST_3X9), InputMenus.Choice.of(ShopType.CHEST_2X9, Material.CHEST, "2x9 chest", this.shop.getShopType() == ShopType.CHEST_2X9), InputMenus.Choice.of(ShopType.CHEST_1X9, Material.CHEST, "1x9 chest", this.shop.getShopType() == ShopType.CHEST_1X9), InputMenus.Choice.of(ShopType.TRADER, Material.EMERALD, "Trader", this.shop.getShopType() == ShopType.TRADER)));
        }

        @MenuSlot(slot={0, 4}, material=Material.NAME_TAG, amount=1)
        public void onSetTitle(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            this.ctx.getMenu().transition(InputMenus.stringSetter(this.shop::getTitle, this.shop::setTitle));
        }

        @MenuSlot(slot={0, 6}, compatMaterial={"COMMAND_BLOCK", "COMMAND"}, amount=1)
        public void onToggleRightClick(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            if (!event.getWhoClicked().hasPermission("citizens.admin") && !event.getWhoClicked().hasPermission("citizens.npc.shop.editor.show-on-right-click")) {
                event.setCancelled(true);
                Messaging.sendTr((CommandSender)event.getWhoClicked(), "citizens.commands.requirements.missing-permission", new Object[0]);
                return;
            }
            event.setCancelled(true);
            if (this.trait == null) {
                return;
            }
            if (this.shop.getName().equals(this.trait.rightClickShop)) {
                this.trait.rightClickShop = null;
            } else {
                this.trait.rightClickShop = this.shop.name;
            }
            this.ctx.getSlot(6).setDescription("<f>Show shop on right click<br>" + this.shop.getName().equals(this.trait.rightClickShop));
        }

        @MenuSlot(slot={1, 1}, material=Material.ENDER_CHEST, amount=1, title="<f>View inventory")
        public void onViewItemStorage(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            this.ctx.getMenu().transition(this.storage.createInventoryViewer(event.getWhoClicked()));
        }
    }

    public static class NPCShopPurchaseEvent
    extends Event {
        private final NPCShopItem item;
        private final Player player;
        private final NPCShop shop;
        private static final HandlerList HANDLERS = new HandlerList();

        public NPCShopPurchaseEvent(Player player, NPCShop shop, NPCShopItem item) {
            this.player = player;
            this.shop = shop;
            this.item = item;
        }

        public HandlerList getHandlers() {
            return HANDLERS;
        }

        public NPCShopItem getItem() {
            return this.item;
        }

        public Player getPlayer() {
            return this.player;
        }

        public NPCShop getShop() {
            return this.shop;
        }
    }

    @Menu(title="NPC Shop Page Editor", type=InventoryType.CHEST, dimensions={5, 9})
    public static class NPCShopPageSettings
    extends InventoryMenuPage {
        private MenuContext ctx;
        private final NPCShopPage page;

        public NPCShopPageSettings(NPCShopPage page) {
            this.page = page;
        }

        @MenuSlot(slot={0, 4}, material=Material.FEATHER, amount=1)
        public void editPageTitle(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            this.ctx.getMenu().transition(InputMenus.stringSetter(() -> this.page.title, newTitle -> this.page.title = newTitle.isEmpty() ? null : newTitle));
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.ctx = ctx;
            ctx.getSlot(4).setDescription("Set page title<br>Currently: " + this.page.title);
        }

        @MenuSlot(slot={4, 4}, material=Material.TNT, amount=1, title="<c>Remove page")
        public void removePage(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            this.ctx.data().put("removePage", this.page.index);
            this.ctx.getMenu().transitionBack();
        }
    }

    public static class NPCShopPage {
        @Persist(value="$key")
        private int index;
        @Persist(keyType=Integer.class, reify=true)
        private final Map<Integer, NPCShopItem> items = Maps.newHashMap();
        @Persist
        private String title;

        private NPCShopPage() {
        }

        public NPCShopPage(int page) {
            this.index = page;
        }

        public NPCShopItem getItem(int idx) {
            return this.items.get(idx);
        }

        public ItemStack getNextPageItem(Player player, int idx) {
            return this.items.containsKey(idx) ? this.items.get(idx).getDisplayItem(player) : new ItemStack(Material.FEATHER, 1);
        }

        public ItemStack getPreviousPageItem(Player player, int idx) {
            return this.items.containsKey(idx) ? this.items.get(idx).getDisplayItem(player) : new ItemStack(Material.FEATHER, 1);
        }

        public void removeItem(int idx) {
            this.items.remove(idx);
        }

        public void setItem(int idx, NPCShopItem modified) {
            this.items.put(idx, modified);
        }
    }

    @Menu(title="NPC Shop Item Editor", type=InventoryType.CHEST, dimensions={6, 9})
    public static class NPCShopItemEditor
    extends InventoryMenuPage {
        @MenuPattern(offset={0, 6}, slots={@MenuSlot(pat=120, material=Material.AIR)}, value="xxx\nxxx\nxxx")
        private InventoryMenuPattern actionItems;
        private NPCShopItem base;
        private final Consumer<NPCShopItem> callback;
        @MenuPattern(offset={0, 0}, slots={@MenuSlot(pat=120, material=Material.AIR)}, value="xxx\nxxx\nxxx")
        private InventoryMenuPattern costItems;
        private MenuContext ctx;
        private final NPCShopItem modified;

        public NPCShopItemEditor(NPCShopItem item, Consumer<NPCShopItem> consumer) {
            this.base = item;
            this.modified = this.base.clone();
            this.callback = consumer;
        }

        private ItemStack editTitle(ItemStack item, Function<String, String> transform) {
            ItemMeta meta;
            meta.setDisplayName(transform.apply((meta = item.getItemMeta()).hasDisplayName() ? meta.getDisplayName() : ""));
            item.setItemMeta(meta);
            return item;
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.ctx = ctx;
            if (this.modified.display != null) {
                ctx.getSlot(40).setItemStack(this.modified.getDisplayItem(null));
            }
            ctx.getSlot(29).setItemStack(new ItemStack(Material.EGG), "Only purchasable once per player", "Times purchasable: " + this.modified.timesPurchasable + (this.modified.timesPurchasable == 0 ? " (no limit)" : ""));
            ctx.getSlot(29).setClickHandler(e -> ctx.getMenu().transition(InputMenus.stringSetter(() -> String.valueOf(this.modified.timesPurchasable), s -> {
                this.modified.timesPurchasable = Integer.parseInt(s);
                ctx.getSlot(38).setDescription("Times purchasable: " + this.modified.timesPurchasable + (this.modified.timesPurchasable == 0 ? " (no limit)" : ""));
            })));
            ctx.getSlot(38).setItemStack(new ItemStack(Util.getFallbackMaterial("OAK_SIGN", "SIGN")), "Set already purchased message, currently:\n", this.modified.alreadyPurchasedMessage == null ? "Unset" : this.modified.alreadyPurchasedMessage);
            ctx.getSlot(38).setClickHandler(e -> InputMenus.runChatStringSetter(ctx.getMenu(), e, "Enter the new already purchased message, currently:<br>[[" + this.modified.alreadyPurchasedMessage, s -> {
                this.modified.alreadyPurchasedMessage = s;
                ctx.getSlot(38).setDescription(this.modified.alreadyPurchasedMessage);
            }));
            ctx.getSlot(30).setItemStack(new ItemStack(Util.getFallbackMaterial("GREEN_WOOL", "EMERALD", "OAK_SIGN", "SIGN")), "Set successful click message, currently:\n", this.modified.resultMessage == null ? "Unset" : this.modified.resultMessage);
            ctx.getSlot(30).setClickHandler(e -> InputMenus.runChatStringSetter(ctx.getMenu(), e, "Enter the new successful click message, currently:<br>[[" + this.modified.resultMessage, s -> {
                this.modified.resultMessage = s;
                ctx.getSlot(30).setDescription(this.modified.resultMessage);
            }));
            ctx.getSlot(33).setItemStack(new ItemStack(Util.getFallbackMaterial("RED_WOOL", "OAK_SIGN", "SIGN")), "Set unsuccessful click message, currently:\n", this.modified.costMessage == null ? "Unset" : this.modified.costMessage);
            ctx.getSlot(33).setClickHandler(e -> InputMenus.runChatStringSetter(ctx.getMenu(), e, "Enter the new unsuccessful click message, currently:<br>[[" + this.modified.costMessage, s -> {
                this.modified.costMessage = s;
                ctx.getSlot(33).setDescription(this.modified.costMessage);
            }));
            ctx.getSlot(32).setItemStack(new ItemStack(Util.getFallbackMaterial("FEATHER", "OAK_SIGN", "SIGN")), "Set click to confirm message.", "For example, 'click again to buy this item'\nYou can use <cost> or <result> placeholders.\nCurrently:\n" + (this.modified.clickToConfirmMessage == null ? "Unset" : this.modified.clickToConfirmMessage));
            ctx.getSlot(32).setClickHandler(e -> InputMenus.runChatStringSetter(ctx.getMenu(), e, "Enter the new click to confirm message, currently:<br>[[" + this.modified.clickToConfirmMessage, s -> {
                this.modified.clickToConfirmMessage = s;
                ctx.getSlot(32).setDescription(this.modified.clickToConfirmMessage);
            }));
            ctx.getSlot(31).setItemStack(new ItemStack(Material.REDSTONE), "Sell as many times as possible on shift click\n", "Currently: " + this.modified.maxRepeatsOnShiftClick);
            ctx.getSlot(31).setClickHandler(InputMenus.toggler(res -> this.modified.maxRepeatsOnShiftClick = res, this.modified.maxRepeatsOnShiftClick));
            int pos = 0;
            for (NPCShopAction.GUI template : NPCShopAction.getGUIs()) {
                if (template.createMenuItem(null) == null) continue;
                NPCShopAction oldCost = this.modified.cost.stream().filter(template::manages).findFirst().orElse(null);
                this.costItems.getSlots().get(pos).setItemStack(this.editTitle(template.createMenuItem(oldCost), title -> title + " Cost"));
                this.costItems.getSlots().get(pos).setClickHandler(event -> {
                    if (!event.getWhoClicked().hasPermission("citizens.admin") && !template.canUse(event.getWhoClicked())) {
                        event.setCancelled(true);
                        Messaging.sendTr((CommandSender)event.getWhoClicked(), "citizens.commands.requirements.missing-permission", new Object[0]);
                        return;
                    }
                    ctx.getMenu().transition(template.createEditor(oldCost, cost -> this.modified.changeCost(template::manages, cost)));
                });
                NPCShopAction oldResult = this.modified.result.stream().filter(template::manages).findFirst().orElse(null);
                this.actionItems.getSlots().get(pos).setItemStack(this.editTitle(template.createMenuItem(oldResult), title -> title + " Result"));
                this.actionItems.getSlots().get(pos).setClickHandler(event -> {
                    if (!event.getWhoClicked().hasPermission("citizens.admin") && !template.canUse(event.getWhoClicked())) {
                        event.setCancelled(true);
                        Messaging.sendTr((CommandSender)event.getWhoClicked(), "citizens.commands.requirements.missing-permission", new Object[0]);
                        return;
                    }
                    ctx.getMenu().transition(template.createEditor(oldResult, result -> this.modified.changeResult(template::manages, result)));
                });
                ++pos;
            }
        }

        @MenuSlot(slot={5, 3}, material=Material.REDSTONE_BLOCK, amount=1, title="<7>Cancel")
        public void onCancel(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            this.ctx.getMenu().transitionBack();
        }

        @Override
        public void onClose(HumanEntity who) {
            if (this.base != null && this.base.display == null) {
                this.base = null;
            }
            this.callback.accept(this.base);
        }

        @MenuSlot(slot={4, 5}, material=Material.BOOK, amount=1, title="<f>Set description")
        public void onEditDescription(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            event.setCancelled(true);
            if (this.modified.display == null) {
                return;
            }
            InputMenus.runChatStringSetter(this.ctx.getMenu(), event, "Type the new item description, currently:<br>[[" + (this.modified.display.getItemMeta().hasLore() ? Joiner.on((String)"<br>").skipNulls().join((Iterable)this.modified.display.getItemMeta().getLore()) : "Unset"), description -> {
                ItemMeta meta = this.modified.display.getItemMeta();
                if (description.isEmpty()) {
                    meta.setLore((List)Lists.newArrayList());
                } else {
                    meta.setLore(Messaging.parseComponentsList(description));
                }
                this.modified.display.setItemMeta(meta);
            });
        }

        @MenuSlot(slot={4, 3}, material=Material.NAME_TAG, amount=1, title="<f>Set name")
        public void onEditName(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            event.setCancelled(true);
            if (this.modified.display == null) {
                return;
            }
            this.ctx.getMenu().transition(InputMenus.stringSetter(() -> ((ItemMeta)this.modified.display.getItemMeta()).getDisplayName(), name -> {
                ItemMeta meta = this.modified.display.getItemMeta();
                meta.setDisplayName(ChatColor.RESET + Messaging.parseComponents(name));
                this.modified.display.setItemMeta(meta);
            }));
        }

        @ClickHandler(slot={4, 4})
        public void onModifyDisplayItem(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            event.setCancelled(true);
            if (event.getCursor() != null) {
                event.setCurrentItem(event.getCursor());
                this.modified.setDisplayItem(event.getCursor());
            } else {
                event.setCurrentItem(null);
                this.modified.setDisplayItem(null);
            }
        }

        @MenuSlot(slot={5, 4}, material=Material.TNT, amount=1, title="<c>Remove")
        public void onRemove(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            this.base = null;
            this.ctx.getMenu().transitionBack();
        }

        @MenuSlot(slot={5, 5}, material=Material.EMERALD_BLOCK, amount=1, title="<a>Save")
        public void onSave(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            this.base = this.modified;
            this.ctx.getMenu().transitionBack();
        }
    }

    public static class NPCShopItem
    implements Cloneable {
        @Persist
        private String alreadyPurchasedMessage;
        @Persist
        private String clickToConfirmMessage;
        @Persist
        private List<NPCShopAction> cost = Lists.newArrayList();
        @Persist
        private String costMessage;
        private List<String> defaultLore = ImmutableList.of();
        @Persist
        private ItemStack display;
        @Persist
        private boolean maxRepeatsOnShiftClick;
        @Persist(keyType=UUID.class)
        private final Map<UUID, Integer> purchases = Maps.newHashMap();
        @Persist
        private List<NPCShopAction> result = Lists.newArrayList();
        @Persist
        private String resultMessage;
        @Persist
        private int timesPurchasable = 0;
        private static final Pattern PLACEHOLDER_REGEX = Pattern.compile("<(cost|result|times_purchasable)>", 2);

        public NPCShopItem() {
            ConfigurationSection defaultSettings = Settings.Setting.SHOP_DEFAULT_ITEM_SETTINGS.asSection();
            this.alreadyPurchasedMessage = !defaultSettings.getString("already-purchased-message", "").isEmpty() ? Messaging.parseComponents(defaultSettings.getString("already-purchased-message")) : null;
            this.clickToConfirmMessage = !defaultSettings.getString("click-to-confirm-message", "").isEmpty() ? Messaging.parseComponents(defaultSettings.getString("click-to-confirm-message", "")) : null;
            this.costMessage = !defaultSettings.getString("cost-message", "").isEmpty() ? Messaging.parseComponents(defaultSettings.getString("cost-message")) : null;
            this.resultMessage = !defaultSettings.getString("result-message", "").isEmpty() ? Messaging.parseComponents(defaultSettings.getString("result-message")) : null;
            this.maxRepeatsOnShiftClick = defaultSettings.getBoolean("max-repeats-on-shift-click", false);
            this.timesPurchasable = defaultSettings.getInt("times-purchasable", 0);
            if (!defaultSettings.getString("lore", "").isEmpty()) {
                this.defaultLore = Messaging.parseComponentsList(defaultSettings.getString("lore"));
            }
        }

        private List<NPCShopAction.Transaction> apply(List<NPCShopAction> actions, Function<NPCShopAction, NPCShopAction.Transaction> func) {
            ArrayList pending = Lists.newArrayList();
            for (NPCShopAction action : actions) {
                NPCShopAction.Transaction take = func.apply(action);
                if (!take.isPossible()) {
                    pending.forEach(NPCShopAction.Transaction::rollback);
                    return null;
                }
                take.run();
                pending.add(take);
            }
            return pending;
        }

        private void changeAction(List<NPCShopAction> source, Function<NPCShopAction, Boolean> filter, NPCShopAction delta) {
            for (int i = 0; i < source.size(); ++i) {
                if (!filter.apply(source.get(i)).booleanValue()) continue;
                if (delta == null) {
                    source.remove(i);
                } else {
                    source.set(i, delta);
                }
                return;
            }
            if (delta != null) {
                source.add(delta);
            }
        }

        private void changeCost(Function<NPCShopAction, Boolean> filter, NPCShopAction cost) {
            this.changeAction(this.cost, filter, cost);
        }

        private void changeResult(Function<NPCShopAction, Boolean> filter, NPCShopAction result) {
            this.changeAction(this.result, filter, result);
        }

        public NPCShopItem clone() {
            try {
                NPCShopItem dup = (NPCShopItem)super.clone();
                dup.cost = Lists.newArrayList();
                for (NPCShopAction src : this.cost) {
                    dup.cost.add(src.clone());
                }
                dup.result = Lists.newArrayList();
                for (NPCShopAction src : this.result) {
                    dup.result.add(src.clone());
                }
                return dup;
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }

        public List<NPCShopAction> getCost() {
            return this.cost;
        }

        public ItemStack getDisplayItem(Player player) {
            if (this.display == null) {
                return null;
            }
            ItemStack stack = this.display.clone();
            ItemMeta meta = stack.getItemMeta();
            if (meta.hasDisplayName()) {
                meta.setDisplayName(this.placeholders(meta.getDisplayName(), player));
            }
            if (meta.hasLore()) {
                meta.setLore(Lists.transform((List)meta.getLore(), line -> this.placeholders((String)line, player)));
            }
            stack.setItemMeta(meta);
            return stack;
        }

        public List<NPCShopAction> getResult() {
            return this.result;
        }

        private void onClick(NPCShop shop, NPCShopStorage storage, Player player, InventoryMultiplexer inventory, boolean shiftClick, boolean secondClick) {
            int repeats;
            List<NPCShopAction.Transaction> take;
            if (this.timesPurchasable > 0 && this.purchases.getOrDefault(player.getUniqueId(), 0) == this.timesPurchasable) {
                if (this.alreadyPurchasedMessage != null) {
                    Messaging.sendColorless((CommandSender)player, this.placeholders(this.alreadyPurchasedMessage, player));
                }
                return;
            }
            if (this.clickToConfirmMessage != null && !secondClick) {
                Messaging.sendColorless((CommandSender)player, this.placeholders(this.clickToConfirmMessage, player));
                return;
            }
            int max = Integer.MAX_VALUE;
            if (this.maxRepeatsOnShiftClick && shiftClick) {
                for (NPCShopAction action2 : this.cost) {
                    int r = action2.getMaxRepeats((Entity)player, inventory);
                    if (r == -1) continue;
                    max = Math.min(max, r);
                }
                if (max == 0) {
                    return;
                }
            }
            if ((take = this.apply(this.cost, arg_0 -> NPCShopItem.lambda$onClick$1(storage, player, inventory, repeats = max == Integer.MAX_VALUE ? 1 : max, arg_0))) == null) {
                if (this.costMessage != null) {
                    Messaging.sendColorless((CommandSender)player, this.placeholders(this.costMessage, player));
                }
                return;
            }
            if (this.apply(this.result, action -> action.grant(storage, (Entity)player, inventory, repeats)) == null) {
                take.forEach(NPCShopAction.Transaction::rollback);
                return;
            }
            if (this.resultMessage != null) {
                Messaging.sendColorless((CommandSender)player, this.placeholders(this.resultMessage, player));
            }
            if (this.timesPurchasable > 0) {
                this.purchases.put(player.getUniqueId(), this.purchases.getOrDefault(player.getUniqueId(), 0) + 1);
            }
            if (NPCShopPurchaseEvent.HANDLERS.getRegisteredListeners().length > 0) {
                Bukkit.getPluginManager().callEvent((Event)new NPCShopPurchaseEvent(player, shop, this));
            }
        }

        private String placeholders(String string, Player player) {
            string = Placeholders.replace(string, (OfflinePlayer)player);
            StringBuffer sb = new StringBuffer();
            Matcher matcher = PLACEHOLDER_REGEX.matcher(string);
            while (matcher.find()) {
                if (matcher.group(1).equalsIgnoreCase("times_purchasable")) {
                    matcher.appendReplacement(sb, Integer.toString(this.timesPurchasable));
                    continue;
                }
                matcher.appendReplacement(sb, Joiner.on((String)", ").join(Iterables.transform(matcher.group(1).equalsIgnoreCase("cost") ? this.cost : this.result, NPCShopAction::describe)).replace("$", "\\$").replace("{", "\\{"));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }

        public void setDisplayItem(ItemStack itemstack) {
            ItemStack itemStack = this.display = itemstack == null ? null : itemstack.clone();
            if (this.display == null) {
                return;
            }
            if (!this.defaultLore.isEmpty()) {
                ArrayList output = Lists.newArrayList();
                ItemMeta meta = this.display.getItemMeta();
                for (String lore : this.defaultLore) {
                    if (lore.trim().equals("<itemlore>")) {
                        output.addAll(meta.getLore());
                        continue;
                    }
                    output.add(lore);
                }
                meta.setLore((List)output);
                this.display.setItemMeta(meta);
            }
        }

        private static /* synthetic */ NPCShopAction.Transaction lambda$onClick$1(NPCShopStorage storage, Player player, InventoryMultiplexer inventory, int repeats, NPCShopAction action) {
            return action.take(storage, (Entity)player, inventory, repeats);
        }
    }

    @Menu(title="NPC Shop Contents Editor", type=InventoryType.CHEST, dimensions={5, 9})
    public static class NPCShopContentsEditor
    extends InventoryMenuPage {
        private NPCShopItem copying;
        private MenuContext ctx;
        private int page = 0;
        private final NPCShop shop;

        public NPCShopContentsEditor(NPCShop shop) {
            this.shop = shop;
        }

        public void changePage(int newPage) {
            this.page = newPage;
            this.ctx.setTitle("NPC Shop Contents Editor (" + (newPage + 1) + "/" + (this.shop.pages.size() + 1) + ")");
            NPCShopPage shopPage = this.shop.getOrCreatePage(this.page);
            int i = 0;
            while (i < this.ctx.getInventory().getSize()) {
                InventoryMenuSlot slot = this.ctx.getSlot(i);
                slot.clear();
                if (shopPage.getItem(i) != null) {
                    slot.setItemStack(shopPage.getItem(i).getDisplayItem(null));
                }
                int idx = i++;
                slot.setClickHandler(evt -> {
                    NPCShopItem display = shopPage.getItem(idx);
                    if (display != null && evt.isShiftClick() && evt.getCursorNonNull().getType() == Material.AIR && display.display != null) {
                        this.copying = display.clone();
                        if (!evt.isRightClick()) {
                            shopPage.setItem(idx, null);
                            slot.setItemStack(null);
                        }
                        evt.setCursor(display.getDisplayItem(null));
                        evt.setCancelled(true);
                        return;
                    }
                    if (display == null) {
                        if (this.copying != null && evt.getCursorNonNull().getType() != Material.AIR && evt.getCursorNonNull().equals((Object)this.copying.getDisplayItem(null))) {
                            shopPage.setItem(idx, this.copying);
                            slot.setItemStack(this.copying.getDisplayItem(null));
                            this.copying = null;
                            return;
                        }
                        display = new NPCShopItem();
                        if (evt.getCursor() != null) {
                            display.setDisplayItem(evt.getCursor());
                        }
                    }
                    this.ctx.clearSlots();
                    this.ctx.getMenu().transition(new NPCShopItemEditor(display, modified -> {
                        if (modified == null) {
                            shopPage.removeItem(idx);
                        } else {
                            shopPage.setItem(idx, (NPCShopItem)modified);
                        }
                    }));
                });
            }
            InventoryMenuSlot prev = this.ctx.getSlot(this.shop.getShopType().prevSlotIndex);
            InventoryMenuSlot edit = this.ctx.getSlot(this.shop.getShopType().editSlotIndex);
            InventoryMenuSlot next = this.ctx.getSlot(this.shop.getShopType().nextSlotIndex);
            if (this.page > 0) {
                prev.setItemStack(shopPage.getNextPageItem(null, this.shop.getShopType().prevSlotIndex), "Previous page (" + newPage + ")");
                Consumer<CitizensInventoryClickEvent> prevItemEditor = prev.getClickHandlers().get(0);
                prev.setClickHandler(evt -> {
                    if (evt.isShiftClick()) {
                        prevItemEditor.accept((CitizensInventoryClickEvent)((Object)evt));
                        return;
                    }
                    evt.setCancelled(true);
                    this.changePage(this.page - 1);
                });
            }
            next.setItemStack(shopPage.getNextPageItem(null, this.shop.getShopType().nextSlotIndex), this.page + 1 >= this.shop.pages.size() ? "New page" : "Next page (" + (newPage + 1) + ")");
            Consumer<CitizensInventoryClickEvent> nextItemEditor = next.getClickHandlers().get(0);
            next.setClickHandler(evt -> {
                if (evt.isShiftClick()) {
                    nextItemEditor.accept((CitizensInventoryClickEvent)((Object)evt));
                    return;
                }
                evt.setCancelled(true);
                this.changePage(this.page + 1);
            });
            Consumer<CitizensInventoryClickEvent> editPageItem = edit.getClickHandlers().get(0);
            edit.setItemStack(new ItemStack(Material.BOOK), "Edit page");
            edit.setClickHandler(evt -> {
                if (evt.isShiftClick()) {
                    editPageItem.accept((CitizensInventoryClickEvent)((Object)evt));
                    return;
                }
                this.ctx.getMenu().transition(new NPCShopPageSettings(this.shop.getOrCreatePage(this.page)));
            });
        }

        @Override
        public Inventory createInventory(String title) {
            return Bukkit.createInventory(null, (int)this.shop.getShopType().inventorySize, (String)"NPC Shop Contents Editor");
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.ctx = ctx;
            if (ctx.data().containsKey("removePage")) {
                int index = (Integer)ctx.data().remove("removePage");
                this.shop.removePage(index);
                this.page = Math.max(this.page - 1, 0);
            }
            this.changePage(this.page);
        }
    }
}

