/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin.profile;

import com.google.common.base.Throwables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.skin.profile.ProfileFetchHandler;
import net.citizensnpcs.npc.skin.profile.ProfileFetchResult;
import net.citizensnpcs.npc.skin.profile.ProfileRequest;
import net.citizensnpcs.util.MojangSkinGenerator;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;

class ProfileFetchThread
implements Runnable {
    private final Deque<ProfileRequest> queue = new ArrayDeque<ProfileRequest>();
    private final Map<String, ProfileRequest> requested = new HashMap<String, ProfileRequest>(40);
    private final Object sync = new Object();

    ProfileFetchThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetch(String name, @Nullable ProfileFetchHandler handler) {
        ProfileRequest request;
        Objects.requireNonNull(name);
        name = name.toLowerCase(Locale.ROOT);
        Object object = this.sync;
        synchronized (object) {
            request = this.requested.get(name);
            if (request == null) {
                request = new ProfileRequest(name, handler);
                this.queue.add(request);
                this.requested.put(name, request);
                return;
            }
            if (request.getResult() == ProfileFetchResult.TOO_MANY_REQUESTS) {
                this.queue.add(request);
            }
        }
        if (handler != null) {
            if (request.getResult() == ProfileFetchResult.PENDING || request.getResult() == ProfileFetchResult.TOO_MANY_REQUESTS) {
                ProfileFetchThread.addHandler(request, handler);
            } else {
                ProfileFetchThread.sendResult(handler, request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchForced(String name, ProfileFetchHandler handler) {
        ProfileRequest request;
        Objects.requireNonNull(name);
        name = name.toLowerCase(Locale.ROOT);
        Object object = this.sync;
        synchronized (object) {
            request = this.requested.get(name);
            if (request != null) {
                if (request.getResult() == ProfileFetchResult.TOO_MANY_REQUESTS) {
                    this.queue.add(request);
                } else {
                    this.requested.remove(name);
                    this.queue.remove(request);
                    request = null;
                }
            }
            if (request == null) {
                request = new ProfileRequest(name, handler);
                this.queue.add(request);
                this.requested.put(name, request);
                return;
            }
        }
        if (handler != null) {
            if (request.getResult() == ProfileFetchResult.PENDING || request.getResult() == ProfileFetchResult.TOO_MANY_REQUESTS) {
                ProfileFetchThread.addHandler(request, handler);
            } else {
                ProfileFetchThread.sendResult(handler, request);
            }
        }
    }

    private void fetchRequests(final Collection<ProfileRequest> requests) {
        Objects.requireNonNull(requests);
        ArrayList<String> javaNames = new ArrayList<String>(requests.size());
        ArrayList<String> bedrockNames = new ArrayList<String>(0);
        for (ProfileRequest request : requests) {
            if (Util.isBedrockName(request.getPlayerName())) {
                bedrockNames.add(request.getPlayerName());
                continue;
            }
            javaNames.add(request.getPlayerName());
        }
        NMS.findProfilesByNames(javaNames.toArray(new String[javaNames.size()]), new ProfileLookupCallback(){

            public void onProfileLookupFailed(GameProfile profile, Exception e) {
                this.onProfileLookupFailed(profile.getName(), e);
            }

            public void onProfileLookupFailed(String profileName, Exception e) {
                ProfileRequest request;
                if (Messaging.isDebugging()) {
                    Messaging.debug("Profile lookup for player '" + profileName + "' failed: " + ProfileFetchThread.getExceptionMsg(e));
                    Messaging.debug(Throwables.getStackTraceAsString((Throwable)e));
                }
                if ((request = ProfileFetchThread.findRequest(profileName, requests)) == null) {
                    return;
                }
                if (ProfileFetchThread.isProfileNotFound(e)) {
                    request.setResult(null, ProfileFetchResult.NOT_FOUND);
                } else if (ProfileFetchThread.isTooManyRequests(e)) {
                    request.setResult(null, ProfileFetchResult.TOO_MANY_REQUESTS);
                } else {
                    request.setResult(null, ProfileFetchResult.FAILED);
                }
            }

            public void onProfileLookupSucceeded(GameProfile profile) {
                Messaging.idebug(() -> "Fetched profile " + profile.getId() + " for player " + profile.getName());
                ProfileRequest request = ProfileFetchThread.findRequest(profile.getName(), requests);
                if (request == null) {
                    return;
                }
                try {
                    request.setResult(NMS.fillProfileProperties(profile, true), ProfileFetchResult.SUCCESS);
                }
                catch (Throwable e) {
                    if (Messaging.isDebugging()) {
                        Messaging.debug("Filling profile lookup for player '" + profile.getName() + "' failed: " + ProfileFetchThread.getExceptionMsg(e) + " " + ProfileFetchThread.isTooManyRequests(e));
                        Messaging.debug(Throwables.getStackTraceAsString((Throwable)e));
                    }
                    if (ProfileFetchThread.isTooManyRequests(e)) {
                        request.setResult(null, ProfileFetchResult.TOO_MANY_REQUESTS);
                    }
                    request.setResult(null, ProfileFetchResult.FAILED);
                }
            }
        });
        for (String name : bedrockNames) {
            String strippedName = Util.stripBedrockPrefix(name);
            ProfileRequest request = ProfileFetchThread.findRequest(name, requests);
            try {
                Long xuid = MojangSkinGenerator.getXUIDFromName(strippedName);
                if (xuid == null) {
                    request.setResult(null, ProfileFetchResult.NOT_FOUND);
                    continue;
                }
                request.setResult(MojangSkinGenerator.getFilledGameProfileByXUID(name, xuid), ProfileFetchResult.SUCCESS);
            }
            catch (Exception e) {
                request.setResult(null, ProfileFetchResult.FAILED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<ProfileRequest> requests;
        Object object = this.sync;
        synchronized (object) {
            if (this.queue.isEmpty()) {
                return;
            }
            requests = new ArrayList<ProfileRequest>(this.queue);
            this.queue.clear();
        }
        try {
            this.fetchRequests(requests);
        }
        catch (Exception ex) {
            Messaging.severe("Error fetching skins: " + ex.getMessage());
            for (ProfileRequest req : requests) {
                req.setResult(null, ProfileFetchResult.FAILED);
            }
        }
    }

    private static void addHandler(ProfileRequest request, ProfileFetchHandler handler) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> request.addHandler(handler), 1L);
    }

    @Nullable
    private static ProfileRequest findRequest(String name, Collection<ProfileRequest> requests) {
        name = name.toLowerCase(Locale.ROOT);
        for (ProfileRequest request : requests) {
            if (!request.getPlayerName().equals(name)) continue;
            return request;
        }
        return null;
    }

    private static String getExceptionMsg(Throwable e) {
        return Throwables.getRootCause((Throwable)e).getMessage();
    }

    private static boolean isProfileNotFound(Exception e) {
        String message = e.getMessage();
        String cause = e.getCause() != null ? e.getCause().getMessage() : null;
        return message != null && message.contains("did not find") || cause != null && cause.contains("did not find");
    }

    private static boolean isTooManyRequests(Throwable e) {
        String message = e.getMessage();
        String cause = e.getCause() != null ? e.getCause().getMessage() : null;
        return message != null && (message.contains("403 Forbidden") || message.contains("too many requests")) || cause != null && (cause.contains("403 Forbidden") || cause.contains("too many requests"));
    }

    private static void sendResult(ProfileFetchHandler handler, ProfileRequest request) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> handler.onResult(request), 1L);
    }
}

