/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R3.entity;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_21_R3.network.EmptyConnection;
import net.citizensnpcs.nms.v1_21_R3.network.EmptyPacketListener;
import net.citizensnpcs.nms.v1_21_R3.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_21_R3.util.EmptyServerStatsCounter;
import net.citizensnpcs.nms.v1_21_R3.util.MobAI;
import net.citizensnpcs.nms.v1_21_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder,
SkinnableEntity,
MobAI.ForwardingMobAI {
    private AdvancementDataPlayer advancements;
    private final MobAI ai;
    private int jumpTicks = 0;
    private final CitizensNPC npc;
    private boolean setBukkitEntity;
    private final SkinPacketTracker skinTracker;
    private EmptyServerStatsCounter statsCache;
    private static final float EPSILON = 0.003f;
    private static final MethodHandle GAMEMODE_SETTER = NMS.getFirstMethodHandle(PlayerInteractManager.class, true, EnumGamemode.class, EnumGamemode.class);

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer world, GameProfile gameProfile, ClientInformation ci, NPC npc) {
        super(minecraftServer, world, gameProfile, ci);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.ai = new MobAI.BasicMobAI((EntityLiving)this);
            this.skinTracker = new SkinPacketTracker(this);
            try {
                GAMEMODE_SETTER.invoke(this.h, EnumGamemode.a, null);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.initialise(minecraftServer, ci);
        } else {
            this.ai = null;
            this.skinTracker = null;
        }
    }

    public boolean a(EntityPlayer player) {
        return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
    }

    public boolean a(float f, float f1, DamageSource damagesource) {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.a(f, f1, damagesource);
        }
        return false;
    }

    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag, iblockdata, blockposition);
        }
    }

    public void a(DamageSource damagesource) {
        if (this.be) {
            return;
        }
        super.a(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> {
            ((WorldServer)this.dV()).a((EntityPlayer)this, Entity.RemovalReason.a);
            ((WorldServer)this.dV()).m().a((net.minecraft.world.entity.Entity)this);
        }, 15L);
    }

    public void i() {
        boolean navigating;
        if (this.npc == null) {
            super.i();
            return;
        }
        NMSImpl.callNPCMoveEvent(this.npc, (net.minecraft.world.entity.Entity)this);
        super.az();
        boolean bl = navigating = this.npc.getNavigator().isNavigating() || this.ai.getMoveControl().b();
        if (!(navigating || this.getBukkitEntity() == null || this.npc.hasTrait(Gravity.class) && !this.npc.getOrAddTrait(Gravity.class).hasGravity() || !Util.isLoaded(this.getBukkitEntity().getLocation()) || this.npc.isProtected() && !SpigotUtil.checkYSafe(this.dC(), this.getBukkitEntity().getWorld()))) {
            this.moveWithFallDamage(Vec3D.c);
        }
        Vec3D mot = this.dy();
        if (Math.abs(mot.d) < (double)0.003f && Math.abs(mot.e) < (double)0.003f && Math.abs(mot.f) < (double)0.003f) {
            this.i(Vec3D.c);
        }
        if (navigating) {
            if (!this.ai.getNavigation().k()) {
                this.ai.getNavigation().c();
            }
            this.moveOnCurrentHeading();
        }
        this.tickAI();
        this.aK();
        this.ad = this.Z_();
        if (this.Z_()) {
            this.aD = false;
        }
        this.o();
        if (this.npc.useMinecraftAI()) {
            this.ce.a((EntityPlayer)this);
        }
        if (this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(false)).booleanValue()) {
            if (this.cj > 0) {
                --this.cj;
            }
            AxisAlignedBB axisalignedbb = this.bZ() && !this.dk().dQ() ? this.cR().b(this.dk().cR()).c(1.0, 0.0, 1.0) : this.cR().c(1.0, 0.5, 1.0);
            for (net.minecraft.world.entity.Entity entity : this.dV().a_((net.minecraft.world.entity.Entity)this, axisalignedbb)) {
                entity.a_((EntityHuman)this);
            }
        }
        ++this.aS;
        this.gE().a();
        EntityPoseTrait ept = this.npc.getTraitNullable(EntityPoseTrait.class);
        if (ept == null || ept.getPose() == null) {
            this.gc();
        }
    }

    public AdvancementDataPlayer S() {
        if (this.npc == null) {
            return super.S();
        }
        if (this.advancements == null) {
            this.advancements = new EmptyAdvancementDataPlayer(this.cV().aC(), this.cV().ag(), this);
        }
        return this.advancements;
    }

    @Override
    public MobAI getAI() {
        return this.ai;
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !this.setBukkitEntity) {
            NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PlayerNPC(this));
            this.setBukkitEntity = true;
        }
        return super.getBukkitEntity();
    }

    protected SoundEffect o_() {
        return NMSImpl.getSoundEffect(this.npc, super.o_(), NPC.Metadata.DEATH_SOUND);
    }

    protected SoundEffect e(DamageSource damagesource) {
        return NMSImpl.getSoundEffect(this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
    }

    public float fj() {
        return NMS.getJumpPower(this.npc, super.fj());
    }

    public int cE() {
        return NMS.getFallDistance(this.npc, super.cE());
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    public EnumPistonReaction n_() {
        return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.n_();
    }

    @Override
    public GameProfile getProfile() {
        return super.gh();
    }

    @Override
    public String getSkinName() {
        String skinName = this.npc.getOrAddTrait(SkinTrait.class).getSkinName();
        if (skinName == null) {
            skinName = this.npc.getName();
        }
        return skinName.toLowerCase();
    }

    @Override
    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public ServerStatisticManager I() {
        return this.statsCache == null ? (this.statsCache = new EmptyServerStatsCounter()) : this.statsCache;
    }

    public IChatBaseComponent O() {
        if (this.npc != null && this.npc.shouldRemoveFromTabList()) {
            return IChatMutableComponent.a((ComponentContents)new LiteralContents.a(""));
        }
        return this.npc != null ? (IChatBaseComponent)Messaging.minecraftComponentFromRawMessage(this.npc.getRawName()) : super.O();
    }

    public boolean a(WorldServer level, DamageSource damagesource, float f) {
        boolean damaged = super.a(level, damagesource, f);
        if (damaged && this.T) {
            this.T = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> {
                this.T = true;
            });
        }
        return damaged;
    }

    private void initialise(MinecraftServer minecraftServer, ClientInformation clientInfo) {
        try {
            EmptyConnection conn = new EmptyConnection(EnumProtocolDirection.b);
            this.f = new EmptyPacketListener(minecraftServer, conn, this, new CommonListenerCookie(this.getProfile(), 0, clientInfo, false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.w(true);
        this.setSkinFlags((byte)-1);
    }

    public boolean bM() {
        if (this.npc == null || this.ad || this.fR()) {
            return super.bM();
        }
        return Util.inBlock((Entity)this.getBukkitEntity());
    }

    public boolean bI() {
        return this.npc == null ? super.bI() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
    }

    public void p(double strength, double dx, double dz) {
        NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
    }

    private void moveOnCurrentHeading() {
        if (this.bm) {
            if (this.aD && this.jumpTicks == 0) {
                this.s();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.bn *= 0.98f;
        this.bp *= 0.98f;
        this.moveWithFallDamage(new Vec3D((double)this.bn, (double)this.bo, (double)this.bp));
        NMS.setHeadAndBodyYaw((Entity)this.getBukkitEntity(), this.dL());
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(Vec3D vec) {
        double x = this.dA();
        double y = this.dC();
        double z = this.dG();
        this.a_(vec);
        if (!this.npc.isProtected()) {
            this.a(this.dA() - x, this.dC() - y, this.dG() - z, this.aD);
        }
    }

    public boolean q_() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.q_();
        }
        return false;
    }

    public void h(net.minecraft.world.entity.Entity entity) {
        super.h(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
        }
    }

    public void a(Entity.RemovalReason reason) {
        super.a(reason);
        this.S().b();
    }

    @Override
    public void setSkinFlags(byte flags) {
        this.au().a(EntityHuman.bW, (Object)flags);
    }

    @Override
    public void setSkinName(String name) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name);
    }

    @Override
    public void setSkinName(String name, boolean forceUpdate) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name, forceUpdate);
    }

    @Override
    public void setSkinPersistent(String skinName, String signature, String data) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinPersistent(skinName, signature, data);
    }

    public void h() {
        super.h();
        if (this.npc == null) {
            return;
        }
        this.detectEquipmentUpdatesPublic();
        float scale = this.ej();
        if (scale != this.bF) {
            this.bF = scale;
            this.m_();
        }
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.getBukkitEntity());
        this.updatePackets(this.npc.getNavigator().isNavigating());
        this.npc.update();
        if (NMSImpl.PAPER_PLAYER_MOB_COUNTS != null && this.npc.shouldRemoveFromPlayerList()) {
            try {
                int[] counts = NMSImpl.PAPER_PLAYER_MOB_COUNTS.invoke(this);
                for (int i = 0; i < counts.length; ++i) {
                    counts[i] = 0;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void tickAI() {
        this.ai.getMoveControl().a();
        this.ai.getJumpControl().b();
    }

    public void a_(Vec3D vec3d) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a_(vec3d);
        } else {
            NMSImpl.moveLogic((EntityLiving)this, vec3d);
        }
    }

    public boolean a(TagKey<FluidType> tagkey, double d0) {
        Vec3D old = this.dy().b(0.0, 0.0, 0.0);
        boolean res = super.a(tagkey, d0);
        if (!this.npc.isPushableByFluids()) {
            this.i(old);
        }
        return res;
    }

    private void updatePackets(boolean navigating) {
        if (!this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        this.bY = true;
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity {
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entity);
            this.npc = entity.npc;
            this.npc.getOrAddTrait(Inventory.class);
        }

        public boolean canSee(Entity entity) {
            if (entity != null && entity.getType().name().contains("ITEM_FRAME")) {
                return false;
            }
            return super.canSee(entity);
        }

        @Override
        public Player getBukkitEntity() {
            return this;
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        @Override
        public String getSkinName() {
            return ((SkinnableEntity)this.entity).getSkinName();
        }

        @Override
        public SkinPacketTracker getSkinTracker() {
            return ((SkinnableEntity)this.entity).getSkinTracker();
        }

        public boolean hasMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }

        @Override
        public void setSkinFlags(byte flags) {
            ((SkinnableEntity)this.entity).setSkinFlags(flags);
        }

        @Override
        public void setSkinName(String name) {
            ((SkinnableEntity)this.entity).setSkinName(name);
        }

        @Override
        public void setSkinName(String skinName, boolean forceUpdate) {
            ((SkinnableEntity)this.entity).setSkinName(skinName, forceUpdate);
        }

        @Override
        public void setSkinPersistent(String skinName, String signature, String data) {
            ((SkinnableEntity)this.entity).setSkinPersistent(skinName, signature, data);
        }
    }
}

