/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.function.BiFunction;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.Equipment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@TraitName(value="mirrortrait")
public class MirrorTrait
extends Trait {
    @Persist
    private volatile boolean enabled;
    private volatile BiFunction<Player, Equipment.EquipmentSlot, ItemStack> equipmentFunction;
    @Persist
    private volatile boolean mirrorEquipment;
    @Persist
    private volatile boolean mirrorName;
    private static final BiFunction<Player, Equipment.EquipmentSlot, ItemStack> MIRROR_EQUIPMENT = (player, slot) -> player.getInventory().getItem(slot.toBukkit());

    public MirrorTrait() {
        super("mirrortrait");
    }

    public BiFunction<Player, Equipment.EquipmentSlot, ItemStack> getEquipmentFunction() {
        return this.mirrorEquipment && this.equipmentFunction == null ? MIRROR_EQUIPMENT : this.equipmentFunction;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMirroring(Player player) {
        return this.enabled;
    }

    public boolean isMirroringEquipment() {
        return this.mirrorEquipment;
    }

    public boolean mirrorName() {
        return this.mirrorName;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.npc.isSpawned()) {
            this.npc.despawn(DespawnReason.PENDING_RESPAWN);
            this.npc.spawn(this.npc.getStoredLocation(), SpawnReason.RESPAWN);
        }
    }

    public void setEquipmentFunction(BiFunction<Player, Equipment.EquipmentSlot, ItemStack> func) {
        this.equipmentFunction = func;
    }

    public void setMirrorEquipment(boolean mirrorEquipment) {
        this.mirrorEquipment = mirrorEquipment;
    }

    public void setMirrorName(boolean mirror) {
        this.mirrorName = mirror;
    }
}

