/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.hpastar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.hpastar.HPAGraphEdge;

public class HPAGraphNode {
    final List<List<HPAGraphEdge>> edges = new ArrayList<List<HPAGraphEdge>>();
    final int x;
    final int y;
    final int z;

    public HPAGraphNode(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void connect(int level, HPAGraphNode to, HPAGraphEdge.EdgeType type, float weight) {
        while (level >= this.edges.size()) {
            this.edges.add(new ArrayList());
        }
        while (level >= to.edges.size()) {
            to.edges.add(new ArrayList());
        }
        this.edges.get(level).add(new HPAGraphEdge(this, to, type, weight));
        to.edges.get(level).add(new HPAGraphEdge(to, this, type, weight));
    }

    public double distance(HPAGraphNode dest) {
        return Math.sqrt(Math.pow(this.x - dest.x, 2.0) + Math.pow(this.y - dest.y, 2.0) + Math.pow(this.z - dest.z, 2.0));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HPAGraphNode other = (HPAGraphNode)obj;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public List<HPAGraphEdge> getEdges(int level) {
        if (level >= this.edges.size()) {
            return Collections.emptyList();
        }
        return this.edges.get(level);
    }

    public int hashCode() {
        return 31 * (31 * (31 + this.x) + this.y) + this.z;
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.z;
    }
}

