/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.hpastar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Consumer;
import net.citizensnpcs.api.hpastar.AStarSolution;
import net.citizensnpcs.api.hpastar.ClusterNode;
import net.citizensnpcs.api.hpastar.Direction;
import net.citizensnpcs.api.hpastar.HPAEntrance;
import net.citizensnpcs.api.hpastar.HPAGraph;
import net.citizensnpcs.api.hpastar.HPAGraphEdge;
import net.citizensnpcs.api.hpastar.HPAGraphNode;

public class HPACluster {
    private final int clusterSize;
    final int clusterX;
    final int clusterY;
    final int clusterZ;
    private final HPAGraph graph;
    private final int level;
    private final List<HPAGraphNode> nodes = new ArrayList<HPAGraphNode>();

    public HPACluster(HPAGraph graph, int level, int clusterSize, int clusterX, int clusterY, int clusterZ) {
        this.graph = graph;
        this.level = level;
        this.clusterSize = clusterSize;
        this.clusterX = clusterX;
        this.clusterY = clusterY;
        this.clusterZ = clusterZ;
    }

    private HPAGraphNode[] addEntranceNode(HPAEntrance entrance) {
        assert (entrance.minX == entrance.maxX || entrance.minZ == entrance.maxZ);
        if (entrance.maxX - entrance.minX > 6) {
            return new HPAGraphNode[]{this.getOrAddNode(entrance.minX, entrance.minZ), this.getOrAddNode(entrance.maxX, entrance.minZ)};
        }
        if (entrance.maxZ - entrance.minZ > 6) {
            return new HPAGraphNode[]{this.getOrAddNode(entrance.minX, entrance.minZ), this.getOrAddNode(entrance.minX, entrance.maxZ)};
        }
        int x = (int)(entrance.minX == entrance.maxX ? (double)entrance.minX : Math.floor((double)(entrance.minX + entrance.maxX) / 2.0));
        int z = (int)(entrance.minZ == entrance.maxZ ? (double)entrance.minZ : Math.floor((double)(entrance.minZ + entrance.maxZ) / 2.0));
        return new HPAGraphNode[]{this.getOrAddNode(x, z)};
    }

    public void buildFrom(List<HPACluster> clusters) {
        for (HPACluster other : clusters) {
            for (HPAGraphNode node : other.nodes) {
                if (node.x != this.clusterX && node.z != this.clusterZ && node.x != this.clusterX + this.clusterSize - 1 && node.z != this.clusterZ + this.clusterSize - 1) continue;
                this.nodes.add(node);
                for (HPAGraphEdge edge : node.getEdges(this.level - 1)) {
                    if (edge.type != HPAGraphEdge.EdgeType.INTER) continue;
                    edge.from.connect(this.level, edge.to, edge.type, edge.weight);
                }
            }
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            HPAGraphNode node = this.nodes.get(i);
            for (int j = i + 1; j < this.nodes.size(); ++j) {
                HPAGraphNode n2 = this.nodes.get(j);
                float weight = this.graph.pathfind((HPAGraphNode)node, (HPAGraphNode)n2, (int)(this.level - 1)).cost;
                if (!Float.isFinite(weight)) continue;
                node.connect(this.level, n2, HPAGraphEdge.EdgeType.INTRA, weight);
            }
        }
    }

    public void connect(HPACluster other, Direction direction) {
        HPAEntrance entrance = null;
        switch (direction) {
            case EAST: {
                for (int z = 0; z < this.clusterSize; ++z) {
                    if (this.offsetWalkable(this.clusterSize - 1, z) && other.offsetWalkable(0, z)) {
                        if (entrance == null) {
                            entrance = new HPAEntrance();
                            entrance.minX = entrance.maxX = this.clusterSize - 1;
                            entrance.minZ = z;
                        }
                        entrance.maxZ = z;
                        continue;
                    }
                    if (entrance == null) continue;
                    this.connectEntrance(other, entrance, e -> {
                        e.maxX = 0;
                        e.minX = 0;
                    });
                    entrance = null;
                }
                if (entrance == null) break;
                this.connectEntrance(other, entrance, e -> {
                    e.maxX = 0;
                    e.minX = 0;
                });
                break;
            }
            case WEST: {
                for (int z = 0; z < this.clusterSize; ++z) {
                    if (this.offsetWalkable(0, z) && other.offsetWalkable(this.clusterSize - 1, z)) {
                        if (entrance == null) {
                            entrance = new HPAEntrance();
                            entrance.maxX = 0;
                            entrance.minX = 0;
                            entrance.minZ = z;
                        }
                        entrance.maxZ = z;
                        continue;
                    }
                    if (entrance == null) continue;
                    this.connectEntrance(other, entrance, e -> {
                        e.minX = e.maxX = this.clusterSize - 1;
                    });
                    entrance = null;
                }
                if (entrance == null) break;
                this.connectEntrance(other, entrance, e -> {
                    e.minX = e.maxX = this.clusterSize - 1;
                });
                break;
            }
            case NORTH: {
                for (int x = 0; x < this.clusterSize; ++x) {
                    if (this.offsetWalkable(x, this.clusterSize - 1) && other.offsetWalkable(x, 0)) {
                        if (entrance == null) {
                            entrance = new HPAEntrance();
                            entrance.minZ = entrance.maxZ = this.clusterSize - 1;
                            entrance.minX = x;
                        }
                        entrance.maxX = x;
                        continue;
                    }
                    if (entrance == null) continue;
                    this.connectEntrance(other, entrance, e -> {
                        e.maxZ = 0;
                        e.minZ = 0;
                    });
                    entrance = null;
                }
                if (entrance == null) break;
                this.connectEntrance(other, entrance, e -> {
                    e.maxZ = 0;
                    e.minZ = 0;
                });
                break;
            }
            case SOUTH: {
                for (int x = 0; x < this.clusterSize; ++x) {
                    if (this.offsetWalkable(x, 0) && other.offsetWalkable(x, this.clusterSize - 1)) {
                        if (entrance == null) {
                            entrance = new HPAEntrance();
                            entrance.maxZ = 0;
                            entrance.minZ = 0;
                            entrance.minX = x;
                        }
                        entrance.maxX = x;
                        continue;
                    }
                    if (entrance == null) continue;
                    this.connectEntrance(other, entrance, e -> {
                        e.minZ = e.maxZ = this.clusterSize - 1;
                    });
                    entrance = null;
                }
                if (entrance == null) break;
                this.connectEntrance(other, entrance, e -> {
                    e.minZ = e.maxZ = this.clusterSize - 1;
                });
            }
        }
    }

    private void connectEntrance(HPACluster other, HPAEntrance entrance, Consumer<HPAEntrance> consumer) {
        HPAGraphNode[] from = this.addEntranceNode(entrance);
        consumer.accept(entrance);
        HPAGraphNode[] to = other.addEntranceNode(entrance);
        for (int i = 0; i < from.length; ++i) {
            from[i].connect(this.level, to[i], HPAGraphEdge.EdgeType.INTER, 1.0f);
        }
    }

    public void connectIntra() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            HPAGraphNode n = this.nodes.get(i);
            for (int j = i + 1; j < this.nodes.size(); ++j) {
                HPAGraphNode n2 = this.nodes.get(j);
                float cost = this.pathfind((HPAGraphNode)n, (HPAGraphNode)n2, (boolean)false).cost;
                n.connect(this.level, n2, HPAGraphEdge.EdgeType.INTRA, cost);
            }
        }
    }

    public boolean contains(HPACluster other) {
        return this.clusterY == other.clusterY && this.clusterX + this.clusterSize > other.clusterX && this.clusterZ + this.clusterSize > other.clusterZ && other.clusterZ >= this.clusterZ && other.clusterX >= this.clusterX;
    }

    private HPAGraphNode getOrAddNode(int x, int z) {
        for (HPAGraphNode node : this.nodes) {
            if (node.x != this.clusterX + x || node.z != this.clusterZ + z) continue;
            return node;
        }
        HPAGraphNode node = new HPAGraphNode(this.clusterX + x, this.clusterY, this.clusterZ + z);
        this.nodes.add(node);
        return node;
    }

    public boolean hasWalkableNodes() {
        for (int i = 0; i < this.clusterSize; ++i) {
            for (int j = 0; j < this.clusterSize; ++j) {
                if (!this.offsetWalkable(i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public void insert(HPAGraphNode node) {
        this.nodes.add(node);
        for (HPAGraphNode other : this.nodes) {
            float cost;
            if (other == node || !Float.isFinite(cost = this.pathfind((HPAGraphNode)node, (HPAGraphNode)other, (boolean)false).cost)) continue;
            node.connect(this.level, other, HPAGraphEdge.EdgeType.INTRA, cost);
        }
    }

    private boolean offsetWalkable(int x, int z) {
        return this.graph.walkable(this.clusterX + x, this.clusterY, this.clusterZ + z);
    }

    private AStarSolution pathfind(HPAGraphNode start, HPAGraphNode dest, boolean getPath) {
        ClusterNode startNode = new ClusterNode(start.x, start.z);
        if (start.x == dest.x && start.y == dest.y && start.z == dest.y) {
            return new AStarSolution(getPath ? null : startNode.reconstructSolution(), 0.0f);
        }
        HashMap<ClusterNode, Float> open = new HashMap<ClusterNode, Float>();
        HashMap<ClusterNode, Float> closed = new HashMap<ClusterNode, Float>();
        PriorityQueue<ClusterNode> frontier = new PriorityQueue<ClusterNode>();
        frontier.add(startNode);
        open.put(startNode, Float.valueOf(startNode.g));
        while (!frontier.isEmpty()) {
            ClusterNode node = (ClusterNode)frontier.poll();
            if (node.x == dest.x && node.z == dest.z) {
                return new AStarSolution(getPath ? null : node.reconstructSolution(), node.g);
            }
            closed.put(node, Float.valueOf(node.g));
            open.remove(node);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    ClusterNode neighbour;
                    if (dx == 0 && dz == 0 || node.x + dx < 0 || node.z + dz < 0 || node.x + dx >= 16 || node.z + dz >= 16 || !this.offsetWalkable(dx, dz) || closed.containsKey(neighbour = new ClusterNode(node.x + dx, node.z + dz))) continue;
                    neighbour.parent = node;
                    neighbour.g = (float)((double)node.g + Math.sqrt(Math.pow(node.x - neighbour.x, 2.0) + Math.pow(node.z - neighbour.z, 2.0)));
                    neighbour.h = (float)Math.sqrt(Math.pow(neighbour.x - dest.x, 2.0) + Math.pow(neighbour.z - dest.z, 2.0));
                    if (open.containsKey(neighbour) && neighbour.g > ((Float)open.get(neighbour)).floatValue()) continue;
                    open.put(neighbour, Float.valueOf(neighbour.g));
                    frontier.add(neighbour);
                }
            }
        }
        return new AStarSolution(null, Float.POSITIVE_INFINITY);
    }

    public void remove(HPAGraphNode ... nodes) {
        for (HPAGraphNode node : nodes) {
            List<List<HPAGraphEdge>> edges2 = node.edges;
            for (int i = 0; i < edges2.size(); ++i) {
                List<HPAGraphEdge> edges = edges2.get(i);
                for (HPAGraphEdge edge : edges) {
                    edge.to.edges.get(i).remove(edge);
                }
            }
            this.nodes.remove(node);
        }
    }

    public String toString() {
        return "C[" + this.level + "] (" + this.clusterX + "," + this.clusterY + "," + this.clusterZ + ")->(" + (this.clusterX + this.clusterSize - 1) + "," + this.clusterY + "," + (this.clusterZ + this.clusterSize - 1) + ")";
    }
}

