/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R6.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R6.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R6.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R6.util.MobAI;
import net.citizensnpcs.nms.v1_21_R6.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R6.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.SkinProperty;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.ClientAsset;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.Mannequin;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftMannequin;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class MannequinController
extends MobEntityController {
    public MannequinController() {
        super(EntityMannequinNPC.class, EntityTypes.aG);
    }

    public org.bukkit.entity.Mannequin getBukkitEntity() {
        return (org.bukkit.entity.Mannequin)super.getBukkitEntity();
    }

    public static class EntityMannequinNPC
    extends Mannequin
    implements NPCHolder,
    SkinnableEntity,
    MobAI.ForwardingMobAI {
        private final MobAI ai;
        private final CitizensNPC npc;
        private final SkinPacketTracker skinTracker;

        public EntityMannequinNPC(EntityTypes<? extends Mannequin> types, World level) {
            this(types, level, null);
        }

        public EntityMannequinNPC(EntityTypes<? extends Mannequin> types, World level, NPC npc) {
            super(level);
            this.npc = (CitizensNPC)npc;
            if (npc != null && !npc.useMinecraftAI()) {
                this.b(true);
                this.skinTracker = new SkinPacketTracker(this);
                this.ai = new MobAI.BasicMobAI((EntityLiving)this);
            } else {
                this.ai = null;
                this.skinTracker = null;
            }
        }

        @Override
        public void applyTexture(SkinProperty property) {
            this.a(ResolvableProfile.a((GameProfile)property.applyProperties(this.k().b())));
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
        }

        protected boolean p(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.p(entity);
        }

        public boolean a(double f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void dR() {
            if (this.npc == null) {
                super.dR();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        @Override
        public GameProfile gameProfile() {
            return this.k().b();
        }

        @Override
        public MobAI getAI() {
            return this.ai;
        }

        public CraftLivingEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new MannequinNPC(this));
            }
            return (CraftLivingEntity)super.getBukkitEntity();
        }

        protected SoundEffect f_() {
            return NMSImpl.getSoundEffect(this.npc, super.f_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect e(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fw() {
            return NMS.getJumpPower(this.npc, super.fw());
        }

        public int cR() {
            return NMS.getFallDistance(this.npc, super.cR());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction p_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.p_();
        }

        @Override
        public SkinPacketTracker getSkinTracker() {
            return this.skinTracker;
        }

        public boolean bU() {
            return this.npc == null ? super.bU() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void o(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.o((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB(this.npc, super.c(vec3));
        }

        public boolean fe() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.fe();
            }
            return false;
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc == null) {
                super.a(datawatcherobject);
                return;
            }
            NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject, x$0 -> super.a(x$0));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean c(ValueOutput save) {
            return this.npc == null ? super.c(save) : false;
        }

        @Override
        public void setSkinFlags(byte flags) {
            this.aC().a(Avatar.t, (Object)flags);
        }

        @Override
        public void setSkinPatch(SkinnableEntity.PlayerSkinModelType type, NamespacedKey body, NamespacedKey cape, NamespacedKey elytra) {
            this.a((ResolvableProfile)new ResolvableProfile.Static(Either.left((Object)this.k().b()), new PlayerSkin.Patch(body == null ? Optional.empty() : Optional.of(new ClientAsset.b(MinecraftKey.a((String)body.getNamespace(), (String)body.getKey()))), cape == null ? Optional.empty() : Optional.of(new ClientAsset.b(MinecraftKey.a((String)cape.getNamespace(), (String)cape.getKey()))), elytra == null ? Optional.empty() : Optional.of(new ClientAsset.b(MinecraftKey.a((String)elytra.getNamespace(), (String)elytra.getKey()))), Optional.of(type == SkinnableEntity.PlayerSkinModelType.SLIM ? PlayerModelType.a : PlayerModelType.b))));
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void g() {
            super.g();
            if (this.npc == null) {
                return;
            }
            this.npc.update();
            this.tickAI();
        }

        public void m(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.m(vec3d);
            } else {
                NMSImpl.moveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dI().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.k(old);
            }
            return res;
        }
    }

    public static class MannequinNPC
    extends CraftMannequin
    implements ForwardingNPCHolder,
    SkinnableEntity.ForwardingSkinnableEntity {
        public MannequinNPC(EntityMannequinNPC entity) {
            super((CraftServer)Bukkit.getServer(), (Mannequin)entity);
        }

        @Override
        public LivingEntity getBukkitEntity() {
            return (LivingEntity)this.entity;
        }

        @Override
        public SkinnableEntity getUnderlying() {
            return (SkinnableEntity)this.entity;
        }
    }
}

