/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.io.File;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.expr.ExpressionScope;
import net.citizensnpcs.api.ai.tree.expr.Memory;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.templates.TemplateWorkspace;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.TraitTemplateParser;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.npc.ai.tree.BehaviorTreeParser;
import net.citizensnpcs.npc.ai.tree.NPCExpressionContext;

@TraitName(value="behavior")
public class BehaviorTrait
extends Trait {
    private Memory memory;
    private Behavior root;
    private ExpressionScope scope;
    private Map<String, Object> yamlCache;

    public BehaviorTrait() {
        super("behavior");
    }

    public Memory getMemory() {
        return this.memory;
    }

    public ExpressionScope getScope() {
        return this.scope;
    }

    @Override
    public void load(DataKey key) {
        if (key.keyExists("tree")) {
            this.parse(key.getRelative("tree"));
        }
        if (key.keyExists("memory")) {
            if (this.memory == null) {
                this.memory = new Memory();
            }
            this.memory.loadFrom(key.getRelative("memory"));
        }
    }

    @Override
    public void onDespawn() {
        if (this.root != null) {
            this.npc.getDefaultGoalController().removeBehavior(this.root);
            this.root = null;
        }
    }

    private void parse(DataKey yaml) {
        if (!yaml.hasSubKeys()) {
            return;
        }
        this.scope = NPCExpressionContext.createFor(this.npc);
        if (this.memory == null) {
            this.memory = new Memory();
        }
        BehaviorTreeParser parser = new BehaviorTreeParser(CitizensAPI.getBehaviorRegistry());
        this.root = parser.parse(yaml.getSubKeys().iterator().next(), this.npc, this.scope, this.memory);
        if (this.root == null) {
            return;
        }
        this.npc.getDefaultGoalController().addBehavior(new Behavior(){
            private BehaviorStatus lastStatus = null;

            @Override
            public void reset() {
                BehaviorTrait.this.root.reset();
                this.lastStatus = null;
            }

            @Override
            public BehaviorStatus run() {
                BehaviorTrait.this.scope.resetCache();
                this.lastStatus = BehaviorTrait.this.root.run();
                if (this.lastStatus == BehaviorStatus.SUCCESS || this.lastStatus == BehaviorStatus.FAILURE) {
                    BehaviorTrait.this.root.reset();
                }
                return this.lastStatus;
            }

            @Override
            public boolean shouldExecute() {
                return BehaviorTrait.this.root.shouldExecute();
            }
        }, 1);
    }

    @Override
    public void save(DataKey key) {
        if (this.memory != null) {
            this.memory.saveTo(key.getRelative("memory"));
        }
        if (this.yamlCache != null) {
            key.setMap("tree", this.yamlCache);
            this.yamlCache = null;
        }
    }

    public static TraitTemplateParser createTemplateParser() {
        return new TraitTemplateParser(){

            @Override
            public TraitTemplateParser.ShortTemplateParser getShortTemplateParser() {
                return (ctx, cmdCtx) -> {
                    if (cmdCtx.argsLength() < 2) {
                        return null;
                    }
                    String fileName = cmdCtx.getJoinedStrings(1);
                    return this.loadFromFile(ctx.npc, ctx.workspace, fileName);
                };
            }

            @Override
            public TraitTemplateParser.TemplateParser getTemplateParser() {
                return (ctx, key) -> {
                    BehaviorTrait trait = ctx.npc.getOrAddTrait(BehaviorTrait.class);
                    MemoryDataKey memory = new MemoryDataKey();
                    Map<String, Object> values = key.getRelative("tree").getValuesDeep();
                    ((DataKey)memory).setMap("tree", values);
                    trait.yamlCache = values;
                    trait.load(memory);
                    return null;
                };
            }

            private BehaviorTrait loadFromFile(NPC npc, TemplateWorkspace workspace, String fileName) {
                File file;
                File file2 = file = workspace != null ? workspace.getFile(fileName) : null;
                if (file == null) {
                    file = new File(CitizensAPI.getDataFolder(), "behaviors/" + fileName);
                }
                if (!file.exists()) {
                    Messaging.severe("Behavior file not found", fileName);
                    return null;
                }
                YamlStorage storage = new YamlStorage(file);
                if (!storage.load()) {
                    Messaging.severe("Failed to load behavior tree from", fileName);
                    return null;
                }
                BehaviorTrait trait = npc.getOrAddTrait(BehaviorTrait.class);
                MemoryDataKey memory = new MemoryDataKey();
                Map<String, Object> values = storage.getKey("").getValuesDeep();
                ((DataKey)memory).setMap("tree", values);
                trait.yamlCache = values;
                trait.load(memory);
                return null;
            }
        };
    }
}

