/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;

public class SimpleMetadataStore
implements MetadataStore {
    private final Map<String, MetadataObject> metadata = new HashMap<String, MetadataObject>();
    private final Map<NPC.Metadata, MetadataObject> npcMetadata = Maps.newEnumMap(NPC.Metadata.class);

    private void checkPrimitive(Object data) {
        boolean isPrimitive;
        Objects.requireNonNull(data, "data cannot be null");
        boolean bl = isPrimitive = data instanceof String || data instanceof Boolean || data instanceof Number;
        if (!isPrimitive) {
            throw new IllegalArgumentException("data is not primitive");
        }
    }

    @Override
    public MetadataStore clone() {
        SimpleMetadataStore copy = new SimpleMetadataStore();
        copy.metadata.putAll(this.metadata);
        return copy;
    }

    @Override
    public <T> T get(NPC.Metadata key) {
        Objects.requireNonNull(key, "key cannot be null");
        MetadataObject normal = this.npcMetadata.get((Object)key);
        return (T)(normal == null ? null : normal.value);
    }

    @Override
    public <T> T get(NPC.Metadata key, T def) {
        T t = this.get(key);
        return t == null ? def : t;
    }

    @Override
    public <T> T get(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        MetadataObject normal = this.metadata.get(key);
        return (T)(normal == null ? null : normal.value);
    }

    @Override
    public <T> T get(String key, T def) {
        T t = this.get(key);
        return t == null ? def : t;
    }

    @Override
    public boolean has(NPC.Metadata key) {
        Objects.requireNonNull(key, "key cannot be null");
        return this.npcMetadata.containsKey((Object)key);
    }

    @Override
    public boolean has(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        return this.metadata.containsKey(key);
    }

    @Override
    public void loadFrom(DataKey key) {
        this.metadata.entrySet().removeIf(e -> ((MetadataObject)e.getValue()).persistent);
        this.npcMetadata.entrySet().removeIf(e -> ((MetadataObject)e.getValue()).persistent);
        for (DataKey sub : key.getSubKeys()) {
            NPC.Metadata meta = NPC.Metadata.byKey(sub.name());
            if (meta != null) {
                this.npcMetadata.put(meta, new MetadataObject(sub.getRaw(""), true));
                continue;
            }
            this.metadata.put(sub.name(), new MetadataObject(sub.getRaw(""), true));
        }
    }

    @Override
    public void remove(NPC.Metadata key) {
        this.npcMetadata.remove((Object)key);
    }

    @Override
    public void remove(String key) {
        this.metadata.remove(key);
    }

    @Override
    public void saveTo(DataKey key) {
        Objects.requireNonNull(key, "key cannot be null");
        for (Map.Entry<String, MetadataObject> entry : this.metadata.entrySet()) {
            if (!entry.getValue().persistent) continue;
            key.setRaw(entry.getKey(), entry.getValue().value);
        }
        for (Map.Entry<Object, MetadataObject> entry : this.npcMetadata.entrySet()) {
            if (!entry.getValue().persistent) continue;
            key.setRaw(((NPC.Metadata)((Object)entry.getKey())).getKey(), entry.getValue().value);
        }
    }

    @Override
    public void set(NPC.Metadata key, Object data) {
        Objects.requireNonNull(key, "key cannot be null");
        if (data == null) {
            this.remove(key);
        } else {
            if (!key.accepts(data.getClass())) {
                throw new IllegalArgumentException("data must be subtype of " + key.getType());
            }
            this.npcMetadata.put(key, new MetadataObject(data, false));
        }
    }

    @Override
    public void set(String key, Object data) {
        Objects.requireNonNull(key, "key cannot be null");
        if (data == null) {
            this.remove(key);
        } else {
            this.metadata.put(key, new MetadataObject(data, false));
        }
    }

    @Override
    public void setPersistent(NPC.Metadata key, Object data) {
        Objects.requireNonNull(key, "key cannot be null");
        if (data == null) {
            this.remove(key);
        } else {
            if (!key.accepts(data.getClass())) {
                throw new IllegalArgumentException("data must be subtype of " + key.getType());
            }
            if (key.getType().getRawType() != String.class && !key.getType().isPrimitive() && !Primitives.isWrapperType((Class)key.getType().getRawType())) {
                throw new IllegalArgumentException((Object)((Object)key) + " data is not primitive, got: " + data);
            }
            this.npcMetadata.put(key, new MetadataObject(data, true));
        }
    }

    @Override
    public void setPersistent(String key, Object data) {
        Objects.requireNonNull(key, "key cannot be null");
        if (data == null) {
            this.remove(key);
        } else {
            this.checkPrimitive(data);
            this.metadata.put(key, new MetadataObject(data, true));
        }
    }

    @Override
    public int size() {
        return this.metadata.size() + this.npcMetadata.size();
    }

    private static class MetadataObject {
        final boolean persistent;
        final Object value;

        public MetadataObject(Object raw, boolean persistent) {
            this.value = raw;
            this.persistent = persistent;
        }
    }
}

