/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.ItemStack;

@TraitName(value="horsemodifiers")
public class HorseModifiers
extends Trait {
    @Persist(value="armor")
    private ItemStack armor = null;
    @Persist(value="carryingChest")
    private boolean carryingChest;
    @Persist(value="color")
    private Horse.Color color = Horse.Color.CREAMY;
    @Persist(value="saddle")
    private ItemStack saddle = null;
    @Persist(value="style")
    private Horse.Style style = Horse.Style.NONE;
    @Persist(value="tamed")
    private boolean tamed;
    private static boolean SUPPORTS_CARRYING_CHEST;

    public HorseModifiers() {
        super("horsemodifiers");
    }

    public ItemStack getArmor() {
        return this.armor;
    }

    public Horse.Color getColor() {
        return this.color;
    }

    public ItemStack getSaddle() {
        return this.saddle;
    }

    public Horse.Style getStyle() {
        return this.style;
    }

    public boolean isTamed() {
        return this.tamed;
    }

    @Override
    public void onSpawn() {
        this.updateModifiers();
    }

    @Override
    public void run() {
        if (this.npc.getCosmeticEntity() instanceof Horse) {
            Horse horse = (Horse)this.npc.getCosmeticEntity();
            this.saddle = horse.getInventory().getSaddle();
            this.armor = horse.getInventory().getArmor();
        }
    }

    public void setArmor(ItemStack armor) {
        this.armor = armor;
    }

    public void setCarryingChest(boolean carryingChest) {
        this.carryingChest = carryingChest;
        this.updateModifiers();
    }

    public void setColor(Horse.Color color) {
        this.color = color;
        this.updateModifiers();
    }

    public void setSaddle(ItemStack saddle) {
        this.saddle = saddle;
    }

    public void setStyle(Horse.Style style) {
        this.style = style;
        this.updateModifiers();
    }

    public void setTamed(boolean tamed) {
        this.tamed = tamed;
        this.updateModifiers();
    }

    private void updateModifiers() {
        Entity entity = this.npc.getCosmeticEntity();
        if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            horse.setColor(this.color);
            horse.setStyle(this.style);
            horse.getInventory().setArmor(this.armor);
            horse.getInventory().setSaddle(this.saddle);
        }
        if (SUPPORTS_CARRYING_CHEST && entity instanceof ChestedHorse) {
            ((ChestedHorse)entity).setCarryingChest(this.carryingChest);
        }
    }

    static {
        try {
            Class.forName("org.bukkit.entity.ChestedHorse").getMethod("setCarryingChest", Boolean.TYPE);
            SUPPORTS_CARRYING_CHEST = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

