/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin;

import java.util.Objects;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.npc.skin.Skin;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SkinPacketTracker {
    private final SkinnableEntity entity;
    private boolean isRemoved;
    private Skin skin;

    public SkinPacketTracker(SkinnableEntity entity) {
        Objects.requireNonNull(entity);
        this.entity = entity;
        this.skin = Skin.get(entity);
    }

    public Skin getSkin() {
        return this.skin;
    }

    public void notifySkinChange(boolean forceUpdate) {
        this.skin = Skin.get(this.entity, forceUpdate);
        this.skin.applyAndRespawn(this.entity);
    }

    public void updateViewer(Player player) {
        Objects.requireNonNull(player);
        if (this.isRemoved || player.hasMetadata("NPC")) {
            return;
        }
        this.skin.apply(this.entity);
        if (this.entity.getBukkitEntity() instanceof Player && NMS.sendTabListAdd(player, (Player)this.entity.getBukkitEntity()) && this.entity.getNPC().shouldRemoveFromTabList()) {
            CitizensAPI.getScheduler().runEntityTaskLater((Entity)player, () -> NMS.sendTabListRemove(player, (Player)this.entity.getBukkitEntity()), Settings.Setting.TABLIST_REMOVE_PACKET_DELAY.asTicks());
        }
    }
}

