/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import net.citizensnpcs.NPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.entity.CitizensBatNPC;
import net.citizensnpcs.npc.entity.CitizensBlazeNPC;
import net.citizensnpcs.npc.entity.CitizensCaveSpiderNPC;
import net.citizensnpcs.npc.entity.CitizensChickenNPC;
import net.citizensnpcs.npc.entity.CitizensCowNPC;
import net.citizensnpcs.npc.entity.CitizensCreeperNPC;
import net.citizensnpcs.npc.entity.CitizensEnderDragonNPC;
import net.citizensnpcs.npc.entity.CitizensEndermanNPC;
import net.citizensnpcs.npc.entity.CitizensGhastNPC;
import net.citizensnpcs.npc.entity.CitizensGiantNPC;
import net.citizensnpcs.npc.entity.CitizensHumanNPC;
import net.citizensnpcs.npc.entity.CitizensIronGolemNPC;
import net.citizensnpcs.npc.entity.CitizensMagmaCubeNPC;
import net.citizensnpcs.npc.entity.CitizensMushroomCowNPC;
import net.citizensnpcs.npc.entity.CitizensOcelotNPC;
import net.citizensnpcs.npc.entity.CitizensPigNPC;
import net.citizensnpcs.npc.entity.CitizensPigZombieNPC;
import net.citizensnpcs.npc.entity.CitizensSheepNPC;
import net.citizensnpcs.npc.entity.CitizensSilverfishNPC;
import net.citizensnpcs.npc.entity.CitizensSkeletonNPC;
import net.citizensnpcs.npc.entity.CitizensSlimeNPC;
import net.citizensnpcs.npc.entity.CitizensSnowmanNPC;
import net.citizensnpcs.npc.entity.CitizensSpiderNPC;
import net.citizensnpcs.npc.entity.CitizensSquidNPC;
import net.citizensnpcs.npc.entity.CitizensVillagerNPC;
import net.citizensnpcs.npc.entity.CitizensWitchNPC;
import net.citizensnpcs.npc.entity.CitizensWitherNPC;
import net.citizensnpcs.npc.entity.CitizensWolfNPC;
import net.citizensnpcs.npc.entity.CitizensZombieNPC;
import net.citizensnpcs.util.ByIdArray;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class CitizensNPCRegistry
implements NPCRegistry {
    private final ByIdArray<NPC> npcs = new ByIdArray();
    private final NPCDataStore saves;
    private final Map<EntityType, Class<? extends CitizensNPC>> types = new EnumMap<EntityType, Class<? extends CitizensNPC>>(EntityType.class);

    public CitizensNPCRegistry(NPCDataStore store) {
        this.saves = store;
        this.types.put(EntityType.BAT, CitizensBatNPC.class);
        this.types.put(EntityType.BLAZE, CitizensBlazeNPC.class);
        this.types.put(EntityType.CAVE_SPIDER, CitizensCaveSpiderNPC.class);
        this.types.put(EntityType.CHICKEN, CitizensChickenNPC.class);
        this.types.put(EntityType.COW, CitizensCowNPC.class);
        this.types.put(EntityType.CREEPER, CitizensCreeperNPC.class);
        this.types.put(EntityType.ENDER_DRAGON, CitizensEnderDragonNPC.class);
        this.types.put(EntityType.ENDERMAN, CitizensEndermanNPC.class);
        this.types.put(EntityType.GHAST, CitizensGhastNPC.class);
        this.types.put(EntityType.GIANT, CitizensGiantNPC.class);
        this.types.put(EntityType.IRON_GOLEM, CitizensIronGolemNPC.class);
        this.types.put(EntityType.MAGMA_CUBE, CitizensMagmaCubeNPC.class);
        this.types.put(EntityType.MUSHROOM_COW, CitizensMushroomCowNPC.class);
        this.types.put(EntityType.OCELOT, CitizensOcelotNPC.class);
        this.types.put(EntityType.PIG, CitizensPigNPC.class);
        this.types.put(EntityType.PIG_ZOMBIE, CitizensPigZombieNPC.class);
        this.types.put(EntityType.PLAYER, CitizensHumanNPC.class);
        this.types.put(EntityType.SHEEP, CitizensSheepNPC.class);
        this.types.put(EntityType.SILVERFISH, CitizensSilverfishNPC.class);
        this.types.put(EntityType.SKELETON, CitizensSkeletonNPC.class);
        this.types.put(EntityType.SLIME, CitizensSlimeNPC.class);
        this.types.put(EntityType.SNOWMAN, CitizensSnowmanNPC.class);
        this.types.put(EntityType.SPIDER, CitizensSpiderNPC.class);
        this.types.put(EntityType.SQUID, CitizensSquidNPC.class);
        this.types.put(EntityType.VILLAGER, CitizensVillagerNPC.class);
        this.types.put(EntityType.WOLF, CitizensWolfNPC.class);
        this.types.put(EntityType.WITCH, CitizensWitchNPC.class);
        this.types.put(EntityType.WITHER, CitizensWitherNPC.class);
        this.types.put(EntityType.ZOMBIE, CitizensZombieNPC.class);
    }

    public NPC createNPC(EntityType type, int id, String name) {
        CitizensNPC npc = this.getByType(type, id, name);
        if (npc == null) {
            throw new IllegalStateException("Could not create NPC.");
        }
        this.npcs.put(npc.getId(), npc);
        return npc;
    }

    @Override
    public NPC createNPC(EntityType type, String name) {
        return this.createNPC(type, this.generateUniqueId(), name);
    }

    @Override
    public void deregister(NPC npc) {
        this.npcs.remove(npc.getId());
        this.saves.remove(npc);
        npc.despawn();
    }

    @Override
    public void deregisterAll() {
        Iterator<NPC> itr = this.iterator();
        while (itr.hasNext()) {
            NPC npc = itr.next();
            itr.remove();
            npc.despawn();
            for (Trait t : npc.getTraits()) {
                t.onRemove();
            }
            this.saves.remove(npc);
        }
    }

    private int generateUniqueId() {
        int count = 0;
        while (this.getById(count++) != null) {
        }
        return count - 1;
    }

    @Override
    public NPC getById(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("invalid id");
        }
        return this.npcs.get(id);
    }

    private CitizensNPC getByType(EntityType type, int id, String name) {
        Class<? extends CitizensNPC> npcClass = this.types.get(type);
        if (npcClass == null) {
            throw new IllegalArgumentException("Invalid EntityType: " + type);
        }
        try {
            return npcClass.getConstructor(Integer.TYPE, String.class).newInstance(id, name);
        }
        catch (Throwable ex) {
            if (ex.getCause() != null) {
                ex = ex.getCause();
            }
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public NPC getNPC(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof NPCHolder) {
            return ((NPCHolder)entity).getNPC();
        }
        net.minecraft.server.Entity handle = ((CraftEntity)entity).getHandle();
        return handle instanceof NPCHolder ? ((NPCHolder)handle).getNPC() : null;
    }

    @Override
    public boolean isNPC(Entity entity) {
        return this.getNPC(entity) != null;
    }

    @Override
    public Iterator<NPC> iterator() {
        return this.npcs.iterator();
    }
}

