/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;

public class Age
extends Trait
implements Toggleable {
    @Persist
    private int age = 0;
    @Persist
    private boolean locked = true;

    public Age() {
        super("age");
    }

    public void describe(CommandSender sender) {
        Messaging.sendTr(sender, "citizens.traits.age-description", this.npc.getName(), this.age, this.locked);
    }

    private boolean isAgeable() {
        return this.npc.getBukkitEntity() instanceof Ageable;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        if (this.npc.isSpawned() && !(this.npc.getBukkitEntity() instanceof Ageable)) {
            throw new NPCLoadException("NPC must be ageable");
        }
    }

    @Override
    public void onSpawn() {
        if (this.isAgeable()) {
            Ageable entity = (Ageable)this.npc.getBukkitEntity();
            entity.setAge(this.age);
            entity.setAgeLock(this.locked);
        }
    }

    @Override
    public void run() {
        if (!this.locked && this.isAgeable()) {
            this.age = ((Ageable)this.npc.getBukkitEntity()).getAge();
        }
    }

    public void setAge(int age) {
        this.age = age;
        if (this.isAgeable()) {
            ((Ageable)this.npc.getBukkitEntity()).setAge(age);
        }
    }

    @Override
    public boolean toggle() {
        boolean bl = this.locked = !this.locked;
        if (this.isAgeable()) {
            ((Ageable)this.npc.getBukkitEntity()).setAgeLock(this.locked);
        }
        return this.locked;
    }

    public String toString() {
        return "Age{age=" + this.age + ",locked=" + this.locked + "}";
    }
}

