/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar;

import java.util.Iterator;
import net.citizensnpcs.api.astar.AStarGoal;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.AStarStorage;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.SimpleAStarStorage;

public class AStarMachine {
    private final AStarStorage storage;

    private AStarMachine(AStarStorage storage) {
        this.storage = storage;
    }

    private void f(AStarGoal goal, AStarNode node, AStarNode neighbour) {
        float g = node.g + goal.g(neighbour);
        float h = goal.h(node, neighbour);
        neighbour.f = g + h;
        neighbour.g = g;
        neighbour.h = h;
    }

    public Plan run(AStarGoal goal, AStarNode start) {
        this.storage.beginNewGoal();
        this.storage.open(start);
        start.f = goal.getInitialCost(start);
        AStarNode node;
        block0: while ((node = this.storage.removeBestNode()) != null) {
            if (goal.isFinished(node)) {
                return node.buildPlan();
            }
            this.storage.close(node);
            Iterator<AStarNode> i$ = node.getNeighbours().iterator();
            while (true) {
                if (!i$.hasNext()) continue block0;
                AStarNode neighbour = i$.next();
                this.f(goal, node, neighbour);
                if (!this.storage.shouldExamine(neighbour)) continue;
                this.storage.open(neighbour);
                neighbour.parent = start;
            }
            break;
        }
        return null;
    }

    public static AStarMachine createWithDefaultStorage() {
        return AStarMachine.createWithStorage(new SimpleAStarStorage());
    }

    public static AStarMachine createWithStorage(AStarStorage storage) {
        return new AStarMachine(storage);
    }
}

