/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.AStarStorage;

public class SimpleAStarStorage
implements AStarStorage {
    private final Map<AStarNode, Float> closed = Maps.newHashMap();
    private final Map<AStarNode, Float> open = Maps.newHashMap();
    private final Queue<AStarNode> queue = new PriorityQueue<AStarNode>();

    @Override
    public void beginNewGoal() {
        this.queue.clear();
        this.closed.clear();
    }

    @Override
    public void close(AStarNode node) {
        this.closed.put(node, Float.valueOf(node.f));
    }

    @Override
    public void open(AStarNode node) {
        this.queue.offer(node);
        this.open.put(node, Float.valueOf(node.f));
    }

    @Override
    public AStarNode removeBestNode() {
        return this.queue.poll();
    }

    @Override
    public boolean shouldExamine(AStarNode neighbour) {
        Float closedF;
        Float openF = this.open.get(neighbour);
        if (openF != null && openF.floatValue() > neighbour.f) {
            this.open.remove(neighbour);
            openF = null;
        }
        if ((closedF = this.closed.get(neighbour)) != null && closedF.floatValue() > neighbour.f) {
            this.closed.remove(neighbour);
            closedF = null;
        }
        return closedF == null && openF == null;
    }
}

