/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalSelector;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.EntityEnderCrystalMarker;
import net.citizensnpcs.trait.waypoint.LinearWaypointsCompleteEvent;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.triggers.TriggerEditPrompt;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class LinearWaypointProvider
implements WaypointProvider {
    private LinearWaypointGoal currentGoal;
    private NPC npc;
    private final List<Waypoint> waypoints = Lists.newArrayList();

    @Override
    public WaypointEditor createEditor(Player player) {
        return new LinearWaypointEditor(player);
    }

    @Override
    public boolean isPaused() {
        return this.currentGoal.isPaused();
    }

    @Override
    public void load(DataKey key) {
        for (DataKey root : key.getRelative("points").getIntegerSubKeys()) {
            Waypoint waypoint = (Waypoint)((Object)PersistenceLoader.load(Waypoint.class, root));
            if (waypoint == null) continue;
            this.waypoints.add(waypoint);
        }
    }

    @Override
    public void onSpawn(NPC npc) {
        this.npc = npc;
        if (this.currentGoal == null) {
            this.currentGoal = new LinearWaypointGoal();
            CitizensAPI.registerEvents(this.currentGoal);
            npc.getDefaultGoalController().addGoal(this.currentGoal, 1);
        }
    }

    @Override
    public void save(DataKey key) {
        key.removeKey("points");
        key = key.getRelative("points");
        for (int i = 0; i < this.waypoints.size(); ++i) {
            PersistenceLoader.save(this.waypoints.get(i), key.getRelative(i));
        }
    }

    @Override
    public void setPaused(boolean paused) {
        this.currentGoal.setPaused(paused);
    }

    private class LinearWaypointGoal
    implements Goal {
        private Waypoint currentDestination;
        private Iterator<Waypoint> itr;
        private boolean paused;
        private GoalSelector selector;

        private LinearWaypointGoal() {
        }

        private void ensureItr() {
            if (this.itr == null) {
                this.itr = LinearWaypointProvider.this.waypoints.iterator();
            } else if (!this.itr.hasNext()) {
                this.itr = this.getNewIterator();
            }
        }

        private Navigator getNavigator() {
            return LinearWaypointProvider.this.npc.getNavigator();
        }

        private Iterator<Waypoint> getNewIterator() {
            LinearWaypointsCompleteEvent event = new LinearWaypointsCompleteEvent(LinearWaypointProvider.this, LinearWaypointProvider.this.waypoints.iterator());
            Bukkit.getPluginManager().callEvent((Event)event);
            Iterator<Waypoint> next = event.getNextWaypoints();
            return next;
        }

        public boolean isPaused() {
            return this.paused;
        }

        @EventHandler
        public void onNavigationComplete(NavigationCompleteEvent event) {
            if (this.selector == null || !event.getNavigator().equals(this.getNavigator())) {
                return;
            }
            Waypoint from = this.currentDestination;
            this.selector.finish();
            Location finished = event.getNavigator().getTargetAsLocation();
            if (finished == null || from == null) {
                return;
            }
            if (finished.getWorld() != from.getLocation().getWorld()) {
                return;
            }
            if (finished.equals((Object)from.getLocation())) {
                from.onReach(LinearWaypointProvider.this.npc);
            }
        }

        public void onProviderChanged() {
            this.itr = LinearWaypointProvider.this.waypoints.iterator();
            if (this.currentDestination != null) {
                this.selector.finish();
            }
        }

        @Override
        public void reset() {
            this.currentDestination = null;
            this.selector = null;
        }

        @Override
        public void run(GoalSelector selector) {
            if (!this.getNavigator().isNavigating()) {
                selector.finish();
            }
        }

        public void setPaused(boolean pause) {
            if (pause && this.currentDestination != null) {
                this.selector.finish();
            }
            this.paused = pause;
        }

        @Override
        public boolean shouldExecute(GoalSelector selector) {
            if (this.paused || this.currentDestination != null || !LinearWaypointProvider.this.npc.isSpawned() || this.getNavigator().isNavigating()) {
                return false;
            }
            this.ensureItr();
            boolean shouldExecute = this.itr.hasNext();
            if (!shouldExecute) {
                return false;
            }
            this.selector = selector;
            Waypoint next = this.itr.next();
            if (LinearWaypointProvider.this.npc.getBukkitEntity().getLocation().distanceSquared(next.getLocation()) < 3.0) {
                return false;
            }
            this.currentDestination = next;
            this.getNavigator().setTarget(this.currentDestination.getLocation());
            return true;
        }
    }

    private final class LinearWaypointEditor
    extends WaypointEditor {
        Conversation conversation;
        boolean editing = true;
        int editingSlot = LinearWaypointProvider.access$200(LinearWaypointProvider.this).size() - 1;
        private final Player player;
        private boolean showPath;
        Map<Waypoint, Entity> waypointMarkers = Maps.newHashMap();
        private static final int LARGEST_SLOT = 8;

        private LinearWaypointEditor(Player player) {
            this.player = player;
        }

        @Override
        public void begin() {
            Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.begin", new Object[0]);
        }

        private void clearWaypoints() {
            this.editingSlot = 0;
            LinearWaypointProvider.this.waypoints.clear();
            this.destroyWaypointMarkers();
            Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.waypoints-cleared", new Object[0]);
        }

        private void createWaypointMarker(int index, Waypoint waypoint) {
            Entity entity = this.spawnMarker(this.player.getWorld(), waypoint.getLocation().add(0.0, 1.0, 0.0));
            if (entity == null) {
                return;
            }
            entity.setMetadata("waypointindex", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)index));
            this.waypointMarkers.put(waypoint, entity);
        }

        private void createWaypointMarkers() {
            for (int i = 0; i < LinearWaypointProvider.this.waypoints.size(); ++i) {
                this.createWaypointMarker(i, (Waypoint)LinearWaypointProvider.this.waypoints.get(i));
            }
        }

        private void destroyWaypointMarkers() {
            for (Entity entity : this.waypointMarkers.values()) {
                entity.remove();
            }
            this.waypointMarkers.clear();
        }

        @Override
        public void end() {
            if (!this.editing) {
                return;
            }
            if (this.conversation != null) {
                this.conversation.abandon();
            }
            Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.end", new Object[0]);
            this.editing = false;
            if (!this.showPath) {
                return;
            }
            this.destroyWaypointMarkers();
        }

        private String formatLoc(Location location) {
            return String.format("[[%d]], [[%d]], [[%d]]", location.getBlockX(), location.getBlockY(), location.getBlockZ());
        }

        @Override
        public Waypoint getCurrentWaypoint() {
            if (LinearWaypointProvider.this.waypoints.size() == 0 || !this.editing) {
                return null;
            }
            this.normaliseEditingSlot();
            return (Waypoint)LinearWaypointProvider.this.waypoints.get(this.editingSlot);
        }

        private Location getPreviousWaypoint(int fromSlot) {
            if (LinearWaypointProvider.this.waypoints.size() <= 1) {
                return null;
            }
            if (--fromSlot < 0) {
                fromSlot = LinearWaypointProvider.this.waypoints.size() - 1;
            }
            return ((Waypoint)LinearWaypointProvider.this.waypoints.get(fromSlot)).getLocation();
        }

        private void normaliseEditingSlot() {
            this.editingSlot = Math.max(0, Math.min(LinearWaypointProvider.this.waypoints.size() - 1, this.editingSlot));
        }

        @EventHandler
        public void onNPCDespawn(NPCDespawnEvent event) {
            if (event.getNPC().equals(LinearWaypointProvider.this.npc)) {
                Editor.leave(this.player);
            }
        }

        @EventHandler
        public void onNPCRemove(NPCRemoveEvent event) {
            if (event.getNPC().equals(LinearWaypointProvider.this.npc)) {
                Editor.leave(this.player);
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerChat(AsyncPlayerChatEvent event) {
            if (!event.getPlayer().equals(this.player)) {
                return;
            }
            if (event.getMessage().equalsIgnoreCase("triggers")) {
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        LinearWaypointEditor.this.conversation = TriggerEditPrompt.start(LinearWaypointEditor.this.player, LinearWaypointEditor.this);
                    }
                });
                return;
            }
            if (event.getMessage().equalsIgnoreCase("clear")) {
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        LinearWaypointEditor.this.clearWaypoints();
                    }
                });
                return;
            }
            if (!event.getMessage().equalsIgnoreCase("toggle path")) {
                return;
            }
            event.setCancelled(true);
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    LinearWaypointEditor.this.togglePath();
                }
            });
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerInteract(PlayerInteractEvent event) {
            if (!event.getPlayer().equals(this.player) || event.getAction() == Action.PHYSICAL) {
                return;
            }
            if (event.getPlayer().getWorld() != LinearWaypointProvider.this.npc.getBukkitEntity().getWorld()) {
                return;
            }
            if (event.getAction() == Action.LEFT_CLICK_BLOCK || event.getAction() == Action.LEFT_CLICK_AIR) {
                double maxDistance;
                double distance;
                if (event.getClickedBlock() == null) {
                    return;
                }
                event.setCancelled(true);
                Location at = event.getClickedBlock().getLocation();
                Location prev = this.getPreviousWaypoint(this.editingSlot);
                if (prev != null && (distance = at.distanceSquared(prev)) > (maxDistance = Math.pow(LinearWaypointProvider.this.npc.getNavigator().getDefaultParameters().range(), 2.0))) {
                    Messaging.sendErrorTr((CommandSender)this.player, "citizens.editors.waypoints.linear.range-exceeded", Math.sqrt(distance), Math.sqrt(maxDistance), ChatColor.RED);
                    return;
                }
                Waypoint element = new Waypoint(at);
                this.normaliseEditingSlot();
                LinearWaypointProvider.this.waypoints.add(this.editingSlot, element);
                if (this.showPath) {
                    this.createWaypointMarker(this.editingSlot, element);
                }
                this.editingSlot = Math.min(this.editingSlot + 1, LinearWaypointProvider.this.waypoints.size());
                Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.added-waypoint", this.formatLoc(at), this.editingSlot + 1, LinearWaypointProvider.this.waypoints.size());
            } else if (LinearWaypointProvider.this.waypoints.size() > 0) {
                event.setCancelled(true);
                this.normaliseEditingSlot();
                Waypoint waypoint = (Waypoint)LinearWaypointProvider.this.waypoints.remove(this.editingSlot);
                if (this.showPath) {
                    this.removeWaypointMarker(waypoint);
                }
                this.editingSlot = Math.max(0, this.editingSlot - 1);
                Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.removed-waypoint", LinearWaypointProvider.this.waypoints.size(), this.editingSlot + 1);
            }
            LinearWaypointProvider.this.currentGoal.onProviderChanged();
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
            if (!this.player.equals(event.getPlayer()) || !this.showPath) {
                return;
            }
            if (!event.getRightClicked().hasMetadata("waypointindex")) {
                return;
            }
            this.editingSlot = ((MetadataValue)event.getRightClicked().getMetadata("waypointindex").get(0)).asInt();
            Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.edit-slot-set", this.editingSlot, this.formatLoc(((Waypoint)LinearWaypointProvider.this.waypoints.get(this.editingSlot)).getLocation()));
        }

        @EventHandler
        public void onPlayerItemHeldChange(PlayerItemHeldEvent event) {
            if (!event.getPlayer().equals(this.player) || LinearWaypointProvider.this.waypoints.size() == 0) {
                return;
            }
            int previousSlot = event.getPreviousSlot();
            int newSlot = event.getNewSlot();
            if (previousSlot == 0 && newSlot == 8) {
                --this.editingSlot;
            } else if (previousSlot == 8 && newSlot == 0) {
                ++this.editingSlot;
            } else {
                int diff = newSlot - previousSlot;
                if (Math.abs(diff) != 1) {
                    return;
                }
                this.editingSlot += diff > 0 ? 1 : -1;
            }
            this.normaliseEditingSlot();
            Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.edit-slot-set", this.editingSlot, this.formatLoc(((Waypoint)LinearWaypointProvider.this.waypoints.get(this.editingSlot)).getLocation()));
        }

        private void removeWaypointMarker(Waypoint waypoint) {
            Entity entity = this.waypointMarkers.remove(waypoint);
            if (entity != null) {
                entity.remove();
            }
        }

        private Entity spawnMarker(World world, Location at) {
            return NMS.spawnCustomEntity(world, at, EntityEnderCrystalMarker.class, EntityType.ENDER_CRYSTAL);
        }

        private void togglePath() {
            boolean bl = this.showPath = !this.showPath;
            if (this.showPath) {
                this.createWaypointMarkers();
                Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.showing-markers", new Object[0]);
            } else {
                this.destroyWaypointMarkers();
                Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.not-showing-markers", new Object[0]);
            }
        }
    }
}

