/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.command;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.command.Command;
import net.citizensnpcs.command.CommandContext;
import net.citizensnpcs.command.Injector;
import net.citizensnpcs.command.Requirements;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.command.exception.CommandUsageException;
import net.citizensnpcs.command.exception.NoPermissionsException;
import net.citizensnpcs.command.exception.RequirementMissingException;
import net.citizensnpcs.command.exception.ServerCommandException;
import net.citizensnpcs.command.exception.UnhandledCommandException;
import net.citizensnpcs.command.exception.WrappedCommandException;
import net.citizensnpcs.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class CommandManager {
    private final Map<String, Method> commands = new HashMap<String, Method>();
    private Injector injector;
    private final Map<Method, Object> instances = new HashMap<Method, Object>();
    private final Map<Method, Requirements> requirements = new HashMap<Method, Requirements>();
    private final Set<Method> serverCommands = new HashSet<Method>();
    private static final Logger logger = Logger.getLogger(CommandManager.class.getCanonicalName());

    public void execute(org.bukkit.command.Command command, String[] args, CommandSender sender, Object ... methodArgs) throws CommandException {
        String[] newArgs = new String[args.length + 1];
        System.arraycopy(args, 0, newArgs, 1, args.length);
        newArgs[0] = command.getName().toLowerCase();
        Object[] newMethodArgs = new Object[methodArgs.length + 1];
        System.arraycopy(methodArgs, 0, newMethodArgs, 1, methodArgs.length);
        this.executeMethod(null, newArgs, sender, newMethodArgs);
    }

    public void execute(String cmd, String[] args, CommandSender sender, Object ... methodArgs) throws CommandException {
        String[] newArgs = new String[args.length + 1];
        System.arraycopy(args, 0, newArgs, 1, args.length);
        newArgs[0] = cmd;
        Object[] newMethodArgs = new Object[methodArgs.length + 1];
        System.arraycopy(methodArgs, 0, newMethodArgs, 1, methodArgs.length);
        this.executeMethod(null, newArgs, sender, newMethodArgs);
    }

    private void executeMethod(Method parent, String[] args, CommandSender sender, Object[] methodArgs) throws CommandException {
        String cmdName = args[0];
        String modifier = args.length > 1 ? args[1] : "";
        Method method = this.commands.get(cmdName.toLowerCase() + " " + modifier.toLowerCase());
        if (method == null) {
            method = this.commands.get(cmdName.toLowerCase() + " *");
        }
        if (method == null && parent == null) {
            throw new UnhandledCommandException();
        }
        if (!this.serverCommands.contains(method) && methodArgs[1] instanceof ConsoleCommandSender) {
            throw new ServerCommandException();
        }
        if (!this.hasPermission(method, sender) && methodArgs[1] instanceof Player) {
            throw new NoPermissionsException();
        }
        Command cmd = method.getAnnotation(Command.class);
        CommandContext context = new CommandContext(args);
        if (context.argsLength() < cmd.min()) {
            throw new CommandUsageException("citizens.commands.requirements.too-few-arguments", this.getUsage(args, cmd));
        }
        if (cmd.max() != -1 && context.argsLength() > cmd.max()) {
            throw new CommandUsageException("citizens.commands.requirements.too-many-arguments", this.getUsage(args, cmd));
        }
        if (!cmd.flags().contains("*")) {
            for (char flag : context.getFlags()) {
                if (cmd.flags().indexOf(String.valueOf(flag)) != -1) continue;
                throw new CommandUsageException("Unknown flag: " + flag, this.getUsage(args, cmd));
            }
        }
        methodArgs[0] = context;
        Requirements cmdRequirements = this.requirements.get(method);
        if (cmdRequirements != null) {
            this.processRequirements(sender, methodArgs, context, cmdRequirements);
        }
        Object instance = this.instances.get(method);
        try {
            method.invoke(instance, methodArgs);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, "Failed to execute command", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "Failed to execute command", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CommandException) {
                throw (CommandException)e.getCause();
            }
            throw new WrappedCommandException(e.getCause());
        }
    }

    public String[] getAllCommandModifiers(String command) {
        HashSet<String> cmds = new HashSet<String>();
        for (String cmd : this.commands.keySet()) {
            String[] split = cmd.split(" ");
            if (!split[0].equalsIgnoreCase(command) || split.length <= 1) continue;
            cmds.add(split[1]);
        }
        return cmds.toArray(new String[cmds.size()]);
    }

    public CommandInfo getCommand(String rootCommand, String modifier) {
        String joined = Joiner.on((char)' ').join((Object)rootCommand, (Object)modifier, new Object[0]);
        for (Map.Entry<String, Method> entry : this.commands.entrySet()) {
            Command commandAnnotation;
            if (!entry.getKey().equalsIgnoreCase(joined) || (commandAnnotation = entry.getValue().getAnnotation(Command.class)) == null) continue;
            return new CommandInfo(commandAnnotation, this.requirements.get(entry.getValue()));
        }
        return null;
    }

    public List<CommandInfo> getCommands(String command) {
        ArrayList<CommandInfo> cmds = new ArrayList<CommandInfo>();
        for (Map.Entry<String, Method> entry : this.commands.entrySet()) {
            Command commandAnnotation;
            if (!entry.getKey().split(" ")[0].equalsIgnoreCase(command) || (commandAnnotation = entry.getValue().getAnnotation(Command.class)) == null) continue;
            cmds.add(new CommandInfo(commandAnnotation, this.requirements.get(entry.getValue())));
        }
        return cmds;
    }

    private String getUsage(String[] args, Command cmd) {
        StringBuilder command = new StringBuilder();
        command.append("/");
        command.append(args[0] + " ");
        command.append(cmd.usage());
        return command.toString();
    }

    public boolean hasCommand(org.bukkit.command.Command cmd, String modifier) {
        return this.commands.containsKey(cmd.getName().toLowerCase() + " " + modifier.toLowerCase()) || this.commands.containsKey(cmd.getName().toLowerCase() + " *");
    }

    private boolean hasPermission(CommandSender sender, String perm) {
        return sender.hasPermission("citizens." + perm);
    }

    private boolean hasPermission(Method method, CommandSender sender) {
        Command cmd = method.getAnnotation(Command.class);
        return cmd.permission().isEmpty() || this.hasPermission(sender, cmd.permission()) || this.hasPermission(sender, "admin");
    }

    private void processRequirements(CommandSender sender, Object[] methodArgs, CommandContext context, Requirements cmdRequirements) throws RequirementMissingException {
        NPC npc = (NPC)methodArgs[2];
        if (cmdRequirements.selected()) {
            boolean canRedefineSelected = context.hasValueFlag("id") && sender.hasPermission("npc.select");
            String error = Messaging.tr("citizens.commands.requirements.must-have-selected", new Object[0]);
            if (canRedefineSelected && (npc = CitizensAPI.getNPCRegistry().getById(context.getFlagInteger("id"))) == null) {
                error = error + ' ' + Messaging.tr("citizens.commands.id-not-found", context.getFlagInteger("id"));
            }
            if (npc == null) {
                throw new RequirementMissingException(error);
            }
        }
        if (cmdRequirements.ownership() && npc != null && !sender.hasPermission("citizens.admin") && !npc.getTrait(Owner.class).isOwnedBy(sender)) {
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.must-be-owner", new Object[0]));
        }
        if (npc != null) {
            for (Class<? extends Trait> clazz : cmdRequirements.traits()) {
                if (npc.hasTrait(clazz)) continue;
                throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.missing-required-trait", clazz.getSimpleName()));
            }
        }
        if (npc != null) {
            EnumSet<EntityType> types = Sets.newEnumSet(Arrays.asList(cmdRequirements.types()), EntityType.class);
            if (types.contains(EntityType.UNKNOWN)) {
                types = EnumSet.allOf(EntityType.class);
            }
            types.removeAll(Sets.newHashSet((Object[])cmdRequirements.excludedTypes()));
            EntityType type = npc.getTrait(MobType.class).getType();
            if (!types.contains(type)) {
                throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.disallowed-mobtype", type.getName()));
            }
        }
    }

    public void register(Class<?> clazz) {
        this.registerMethods(clazz, null);
    }

    private void registerMethods(Class<?> clazz, Method parent) {
        Object obj = this.injector.getInstance(clazz);
        this.registerMethods(clazz, parent, obj);
    }

    private void registerMethods(Class<?> clazz, Method parent, Object obj) {
        for (Method method : clazz.getMethods()) {
            Class<?> senderClass;
            if (!method.isAnnotationPresent(Command.class)) continue;
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            Command cmd = method.getAnnotation(Command.class);
            for (String alias : cmd.aliases()) {
                for (String modifier : cmd.modifiers()) {
                    this.commands.put(alias + " " + modifier, method);
                }
            }
            Requirements cmdRequirements = null;
            if (method.getDeclaringClass().isAnnotationPresent(Requirements.class)) {
                cmdRequirements = method.getDeclaringClass().getAnnotation(Requirements.class);
            }
            if (method.isAnnotationPresent(Requirements.class)) {
                cmdRequirements = method.getAnnotation(Requirements.class);
            }
            if (this.requirements != null) {
                this.requirements.put(method, cmdRequirements);
            }
            if ((senderClass = method.getParameterTypes()[1]) == CommandSender.class) {
                this.serverCommands.add(method);
            }
            if (isStatic || obj == null) continue;
            this.instances.put(method, obj);
        }
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public static class CommandInfo {
        private final Command commandAnnotation;
        private final Requirements requirements;

        public CommandInfo(Command commandAnnotation, Requirements requirements) {
            this.commandAnnotation = commandAnnotation;
            this.requirements = requirements;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CommandInfo other = (CommandInfo)obj;
            return !(this.commandAnnotation == null ? other.commandAnnotation != null : !this.commandAnnotation.equals(other.commandAnnotation));
        }

        public Command getCommandAnnotation() {
            return this.commandAnnotation;
        }

        public Requirements getRequirements() {
            return this.requirements;
        }

        public int hashCode() {
            return 31 + (this.commandAnnotation == null ? 0 : this.commandAnnotation.hashCode());
        }
    }
}

