/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.editor.Equipable;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.Sheared;
import net.citizensnpcs.trait.WoolColor;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntitySheep;
import net.minecraft.server.World;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftSheep;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class CitizensSheepNPC
extends CitizensMobNPC
implements Equipable {
    public CitizensSheepNPC(int id, String name) {
        super(id, name, EntitySheepNPC.class);
    }

    @Override
    public void equip(Player equipper, ItemStack hand) {
        if (hand.getType() == Material.SHEARS) {
            Messaging.sendTr((CommandSender)equipper, this.getTrait(Sheared.class).toggle() ? "citizens.editors.equipment.sheared-set" : "citizens.editors.equipment.sheared-stopped", this.getName());
        } else if (hand.getType() == Material.INK_SACK) {
            if (this.getBukkitEntity().getColor() == DyeColor.getByData((byte)((byte)(15 - hand.getData().getData())))) {
                return;
            }
            DyeColor color = DyeColor.getByData((byte)((byte)(15 - hand.getData().getData())));
            this.getTrait(WoolColor.class).setColor(color);
            Messaging.sendTr((CommandSender)equipper, "citizens.editors.equipment.sheep-coloured", this.getName(), color.name().toLowerCase().replace("_", " "));
            hand.setAmount(hand.getAmount() - 1);
        } else {
            this.getTrait(WoolColor.class).setColor(DyeColor.WHITE);
            Messaging.sendTr((CommandSender)equipper, "citizens.editors.equipment.sheep-coloured", this.getName(), "white");
        }
    }

    public Sheep getBukkitEntity() {
        return (Sheep)super.getBukkitEntity();
    }

    public static class SheepNPC
    extends CraftSheep
    implements NPCHolder {
        private final CitizensNPC npc;

        public SheepNPC(EntitySheepNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntitySheep)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntitySheepNPC
    extends EntitySheep
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntitySheepNPC(World world) {
            this(world, null);
        }

        public EntitySheepNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
                NMS.setPersistent((EntityLiving)this);
            }
        }

        public void bl() {
            super.bl();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public void collide(net.minecraft.server.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, entity);
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public Entity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new SheepNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

