/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.util.Messaging;
import net.minecraft.server.ControllerLook;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntityTypes;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.Navigation;
import net.minecraft.server.NetworkManager;
import net.minecraft.server.Packet;
import net.minecraft.server.PathfinderGoalSelector;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.material.Stairs;
import org.bukkit.material.Step;
import org.bukkit.util.Vector;
import org.uncommons.maths.random.XORShiftRNG;

public class NMS {
    private static final float DEFAULT_SPEED = 0.4f;
    private static Map<Class<? extends net.minecraft.server.Entity>, Integer> ENTITY_CLASS_TO_INT;
    private static final Map<Class<? extends net.minecraft.server.Entity>, Constructor<? extends net.minecraft.server.Entity>> ENTITY_CONSTRUCTOR_CACHE;
    private static Map<Integer, Class<? extends net.minecraft.server.Entity>> ENTITY_INT_TO_CLASS;
    private static Field GOAL_FIELD;
    private static Field LAND_SPEED_MODIFIER_FIELD;
    private static final Map<EntityType, Float> MOVEMENT_SPEEDS;
    private static Field NAVIGATION_WORLD_FIELD;
    private static Field PATHFINDING_RANGE;
    private static Field PERSISTENT_FIELD;
    private static Set<Integer> SLAB_MATERIALS;
    private static Field SPEED_FIELD;
    private static Set<Integer> STAIR_MATERIALS;
    private static Field THREAD_STOPPER;
    private static final Random RANDOM;

    private NMS() {
    }

    public static void addOrRemoveFromPlayerList(LivingEntity bukkitEntity, boolean remove) {
        if (bukkitEntity == null) {
            return;
        }
        EntityLiving handle = ((CraftLivingEntity)bukkitEntity).getHandle();
        if (handle.world == null) {
            return;
        }
        if (remove) {
            handle.world.players.remove(handle);
        } else if (!handle.world.players.contains(handle)) {
            handle.world.players.add(handle);
        }
    }

    public static void attack(EntityLiving handle, EntityLiving target) {
        int fireAspectLevel;
        boolean success;
        int damage;
        int n = damage = handle instanceof EntityMonster ? ((EntityMonster)handle).c((net.minecraft.server.Entity)target) : 2;
        if (handle.hasEffect(MobEffectList.INCREASE_DAMAGE)) {
            damage += 3 << handle.getEffect(MobEffectList.INCREASE_DAMAGE).getAmplifier();
        }
        if (handle.hasEffect(MobEffectList.WEAKNESS)) {
            damage -= 2 << handle.getEffect(MobEffectList.WEAKNESS).getAmplifier();
        }
        int knockbackLevel = 0;
        if (target instanceof EntityLiving) {
            damage += EnchantmentManager.a((EntityLiving)handle, (EntityLiving)target);
            knockbackLevel += EnchantmentManager.getKnockbackEnchantmentLevel((EntityLiving)handle, (EntityLiving)target);
        }
        if (!(success = target.damageEntity(DamageSource.mobAttack((EntityLiving)handle), damage))) {
            return;
        }
        if (knockbackLevel > 0) {
            target.g((double)(-MathHelper.sin((float)((float)((double)handle.yaw * Math.PI / 180.0))) * (float)knockbackLevel * 0.5f), 0.1, (double)(MathHelper.cos((float)((float)((double)handle.yaw * Math.PI / 180.0))) * (float)knockbackLevel * 0.5f));
            handle.motX *= 0.6;
            handle.motZ *= 0.6;
        }
        if ((fireAspectLevel = EnchantmentManager.getFireAspectEnchantmentLevel((EntityLiving)handle)) > 0) {
            target.setOnFire(fireAspectLevel * 4);
        }
    }

    public static void clearGoals(PathfinderGoalSelector ... goalSelectors) {
        if (GOAL_FIELD == null || goalSelectors == null) {
            return;
        }
        for (PathfinderGoalSelector selector : goalSelectors) {
            try {
                List list = (List)GOAL_FIELD.get(selector);
                list.clear();
            }
            catch (Exception e) {
                Messaging.logTr("citizens.nms-errors.clearing-goals", e.getMessage());
            }
        }
    }

    public static double distance(EntityLiving handle, Vector vector) {
        return Math.sqrt(NMS.distanceSquared(handle, vector));
    }

    public static double distanceSquared(EntityLiving handle, Vector vector) {
        return Math.pow(handle.locX - vector.getX(), 2.0) + Math.pow(handle.locY - vector.getY(), 2.0) + Math.pow(handle.locZ - vector.getZ(), 2.0);
    }

    private static Constructor<? extends net.minecraft.server.Entity> getCustomEntityConstructor(Class<? extends net.minecraft.server.Entity> clazz, EntityType type) throws SecurityException, NoSuchMethodException {
        Constructor<? extends net.minecraft.server.Entity> constructor = ENTITY_CONSTRUCTOR_CACHE.get(clazz);
        if (constructor == null) {
            constructor = clazz.getConstructor(World.class);
            constructor.setAccessible(true);
            ENTITY_CLASS_TO_INT.put(clazz, Integer.valueOf(type.getTypeId()));
            ENTITY_CONSTRUCTOR_CACHE.put(clazz, constructor);
        }
        return constructor;
    }

    private static Field getField(Class<?> clazz, String field) {
        Field f = null;
        try {
            f = clazz.getDeclaredField(field);
            f.setAccessible(true);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.getting-field", field, e.getMessage());
        }
        return f;
    }

    public static float getSpeedFor(EntityLiving from) {
        EntityType entityType = from.getBukkitEntity().getType();
        Float cached = MOVEMENT_SPEEDS.get(entityType);
        if (cached != null) {
            return cached.floatValue();
        }
        if (SPEED_FIELD == null) {
            MOVEMENT_SPEEDS.put(entityType, Float.valueOf(0.4f));
            return 0.4f;
        }
        try {
            float speed = SPEED_FIELD.getFloat(from);
            MOVEMENT_SPEEDS.put(entityType, Float.valueOf(speed));
            return speed;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return 0.4f;
        }
    }

    public static boolean inWater(EntityLiving mcEntity) {
        return mcEntity.I() || mcEntity.J();
    }

    public static void look(ControllerLook controllerLook, EntityLiving handle, EntityLiving target) {
        controllerLook.a((net.minecraft.server.Entity)target, 10.0f, (float)handle.bp());
    }

    public static void look(EntityLiving handle, float yaw, float pitch) {
        handle.yaw = handle.ay = yaw;
        handle.pitch = pitch;
    }

    public static void registerEntityClass(Class<? extends net.minecraft.server.Entity> clazz) {
        if (ENTITY_CLASS_TO_INT.containsKey(clazz)) {
            return;
        }
        Class<? extends net.minecraft.server.Entity> search = clazz;
        while ((search = search.getSuperclass()) != null && net.minecraft.server.Entity.class.isAssignableFrom(search)) {
            if (!ENTITY_CLASS_TO_INT.containsKey(search)) continue;
            int code = ENTITY_CLASS_TO_INT.get(search);
            ENTITY_INT_TO_CLASS.put(code, clazz);
            ENTITY_CLASS_TO_INT.put(clazz, code);
            return;
        }
        throw new IllegalArgumentException("unable to find valid entity superclass");
    }

    public static void sendPacket(Player player, Packet packet) {
        ((CraftPlayer)player).getHandle().netServerHandler.sendPacket(packet);
    }

    public static void setHeadYaw(EntityLiving handle, float yaw) {
        handle.ay = yaw;
    }

    public static void setLandSpeedModifier(EntityLiving handle, float speed) {
        if (LAND_SPEED_MODIFIER_FIELD == null) {
            return;
        }
        try {
            LAND_SPEED_MODIFIER_FIELD.setFloat(handle, speed);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-erorrs.updating-land-modifier", e.getMessage());
        }
    }

    public static void setPersistent(EntityLiving entity) {
        if (PERSISTENT_FIELD == null) {
            return;
        }
        try {
            PERSISTENT_FIELD.set(entity, true);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.error-setting-persistent", e.getMessage());
        }
    }

    public static Entity spawnCustomEntity(org.bukkit.World world, Location at, Class<? extends net.minecraft.server.Entity> clazz, EntityType type) {
        WorldServer handle = ((CraftWorld)world).getHandle();
        net.minecraft.server.Entity entity = null;
        try {
            Constructor<? extends net.minecraft.server.Entity> constructor = NMS.getCustomEntityConstructor(clazz, type);
            entity = constructor.newInstance(handle);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.spawning-custom-entity", e.getMessage());
            return null;
        }
        handle.addEntity(entity);
        entity.setLocation(at.getX(), at.getY(), at.getZ(), at.getYaw(), at.getPitch());
        return entity.getBukkitEntity();
    }

    public static void stopNetworkThreads(NetworkManager manager) {
        if (THREAD_STOPPER == null) {
            return;
        }
        try {
            THREAD_STOPPER.set(manager, false);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.stopping-network-threads", e.getMessage());
        }
    }

    public static void trySwim(EntityLiving handle) {
        NMS.trySwim(handle, 0.04f);
    }

    public static void trySwim(EntityLiving handle, float power) {
        if (RANDOM.nextFloat() < 0.8f && NMS.inWater(handle)) {
            handle.motY += (double)power;
        }
    }

    public static void updateAI(EntityLiving entity) {
        NMS.updateSenses(entity);
        entity.getNavigation().e();
        entity.getControllerMove().c();
        entity.getControllerLook().a();
        entity.getControllerJump().b();
    }

    public static void updateNavigationWorld(Entity entity, org.bukkit.World world) {
        if (NAVIGATION_WORLD_FIELD == null || !(entity instanceof LivingEntity)) {
            return;
        }
        EntityLiving handle = ((CraftLivingEntity)entity).getHandle();
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        try {
            NAVIGATION_WORLD_FIELD.set(handle.getNavigation(), worldHandle);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.updating-navigation-world", e.getMessage());
        }
    }

    public static void updatePathfindingRange(CitizensNPC npc, float pathfindingRange) {
        if (PATHFINDING_RANGE == null) {
            return;
        }
        Navigation navigation = npc.getHandle().getNavigation();
        try {
            PATHFINDING_RANGE.set(navigation, Float.valueOf(pathfindingRange));
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.updating-pathfinding-range", e.getMessage());
        }
    }

    public static void updateSenses(EntityLiving entity) {
        entity.aA().a();
    }

    static {
        ENTITY_CONSTRUCTOR_CACHE = new WeakHashMap<Class<? extends net.minecraft.server.Entity>, Constructor<? extends net.minecraft.server.Entity>>();
        MOVEMENT_SPEEDS = Maps.newEnumMap(EntityType.class);
        SLAB_MATERIALS = Sets.newHashSet();
        STAIR_MATERIALS = Sets.newHashSet();
        RANDOM = new XORShiftRNG();
        THREAD_STOPPER = NMS.getField(NetworkManager.class, "m");
        MOVEMENT_SPEEDS.put(EntityType.CHICKEN, Float.valueOf(0.25f));
        MOVEMENT_SPEEDS.put(EntityType.COW, Float.valueOf(0.2f));
        MOVEMENT_SPEEDS.put(EntityType.CREEPER, Float.valueOf(0.3f));
        MOVEMENT_SPEEDS.put(EntityType.IRON_GOLEM, Float.valueOf(0.15f));
        MOVEMENT_SPEEDS.put(EntityType.MUSHROOM_COW, Float.valueOf(0.2f));
        MOVEMENT_SPEEDS.put(EntityType.OCELOT, Float.valueOf(0.23f));
        MOVEMENT_SPEEDS.put(EntityType.SHEEP, Float.valueOf(0.25f));
        MOVEMENT_SPEEDS.put(EntityType.SNOWMAN, Float.valueOf(0.25f));
        MOVEMENT_SPEEDS.put(EntityType.PIG, Float.valueOf(0.27f));
        MOVEMENT_SPEEDS.put(EntityType.PLAYER, Float.valueOf(1.0f));
        MOVEMENT_SPEEDS.put(EntityType.VILLAGER, Float.valueOf(0.3f));
        LAND_SPEED_MODIFIER_FIELD = NMS.getField(EntityLiving.class, "bO");
        SPEED_FIELD = NMS.getField(EntityLiving.class, "bG");
        NAVIGATION_WORLD_FIELD = NMS.getField(Navigation.class, "b");
        PATHFINDING_RANGE = NMS.getField(Navigation.class, "e");
        GOAL_FIELD = NMS.getField(PathfinderGoalSelector.class, "a");
        PERSISTENT_FIELD = NMS.getField(EntityLiving.class, "persistent");
        try {
            Field field = NMS.getField(EntityTypes.class, "d");
            ENTITY_INT_TO_CLASS = (Map)field.get(null);
            field = NMS.getField(EntityTypes.class, "e");
            ENTITY_CLASS_TO_INT = (Map)field.get(null);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.getting-id-mapping", e.getMessage());
        }
        for (Material material : Material.values()) {
            if (Step.class.isAssignableFrom(material.getData())) {
                SLAB_MATERIALS.add(material.getId());
                continue;
            }
            if (!Stairs.class.isAssignableFrom(material.getData())) continue;
            STAIR_MATERIALS.add(material.getId());
        }
    }
}

