/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.editor.Equipable;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.EntityEnderman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.World;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEnderman;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;

public class CitizensEndermanNPC
extends CitizensMobNPC
implements Equipable {
    public CitizensEndermanNPC(int id, String name) {
        super(id, name, EntityEndermanNPC.class);
    }

    @Override
    public void equip(Player equipper, ItemStack hand) {
        ItemStack set;
        if (!hand.getType().isBlock()) {
            Messaging.sendErrorTr((CommandSender)equipper, "citizens.editors.equipment.invalid-block", new Object[0]);
            return;
        }
        MaterialData carried = this.getBukkitEntity().getCarriedMaterial();
        if (carried.getItemType() == Material.AIR) {
            if (hand.getType() == Material.AIR) {
                Messaging.sendErrorTr((CommandSender)equipper, "citizens.editors.equipment.invalid-block", new Object[0]);
                return;
            }
        } else {
            equipper.getWorld().dropItemNaturally(this.getBukkitEntity().getLocation(), carried.toItemStack(1));
            this.getBukkitEntity().setCarriedMaterial(hand.getData());
        }
        if ((set = hand.clone()).getType() != Material.AIR) {
            set.setAmount(1);
            hand.setAmount(hand.getAmount() - 1);
        }
        this.getTrait(Equipment.class).set(0, set);
    }

    public Enderman getBukkitEntity() {
        return (Enderman)super.getBukkitEntity();
    }

    public static class EntityEndermanNPC
    extends EntityEnderman
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEndermanNPC(World world) {
            this(world, null);
        }

        public EntityEndermanNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
                NMS.setPersistent((EntityLiving)this);
            }
        }

        public void bl() {
            super.bl();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public void bn() {
            if (this.npc == null) {
                super.bn();
            } else {
                NMS.updateAI((EntityLiving)this);
                this.npc.update();
            }
        }

        public void c() {
            if (this.npc == null) {
                super.c();
            } else {
                NMS.updateAI((EntityLiving)this);
                this.npc.update();
            }
        }

        public void collide(net.minecraft.server.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, entity);
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public Entity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new EndermanNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EndermanNPC
    extends CraftEnderman
    implements NPCHolder {
        private final CitizensNPC npc;

        public EndermanNPC(EntityEndermanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderman)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

