/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.citizensnpcs.Settings;
import org.bukkit.ChatColor;

public class StringHelper {
    private static Pattern COLOR_MATCHER;
    private static String GROUP_1;
    private static String GROUP_2;

    public static String capitalize(Object string) {
        String capitalize = string.toString();
        return capitalize.replaceFirst(String.valueOf(capitalize.charAt(0)), String.valueOf(Character.toUpperCase(capitalize.charAt(0))));
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static String parseColors(String parsed) {
        Matcher matcher = COLOR_MATCHER.matcher(parsed);
        String replace = matcher.group(1) != null ? GROUP_1 : GROUP_2;
        return matcher.replaceAll(replace);
    }

    public static String wrap(Object string) {
        return StringHelper.wrap(string, StringHelper.parseColors(Settings.Setting.MESSAGE_COLOUR.asString()));
    }

    public static String wrap(Object string, ChatColor colour) {
        return StringHelper.wrap(string, colour.toString());
    }

    public static String wrap(Object string, String colour) {
        return StringHelper.parseColors(Settings.Setting.HIGHLIGHT_COLOUR.asString()) + string.toString() + colour;
    }

    public static String wrapHeader(Object string) {
        String highlight = Settings.Setting.HIGHLIGHT_COLOUR.asString();
        return highlight + "=====[ " + string.toString() + highlight + " ]=====";
    }

    static {
        GROUP_1 = "\u00a7$1";
        GROUP_2 = "\u00a7$2";
        String colors = "";
        for (ChatColor color : ChatColor.values()) {
            colors = colors + color.getChar();
        }
        COLOR_MATCHER = Pattern.compile("&([COLORS])|<([COLORS])>".replace("COLORS", colors), 2);
    }
}

