/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.citizensnpcs.EventListen;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.ai.CitizensNavigator;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public abstract class CitizensNPC
extends AbstractNPC {
    protected EntityLiving mcEntity;
    private final CitizensNavigator navigator = new CitizensNavigator(this);
    private final List<String> removedTraits = Lists.newArrayList();
    private static final String NPC_METADATA_MARKER = "NPC";

    protected CitizensNPC(int id, String name) {
        super(id, name);
        this.runnables.add(this.navigator);
    }

    protected abstract EntityLiving createHandle(Location var1);

    @Override
    public boolean despawn(DespawnReason reason) {
        if (!this.isSpawned()) {
            return false;
        }
        NPCDespawnEvent event = new NPCDespawnEvent(this, reason);
        if (reason == DespawnReason.CHUNK_UNLOAD) {
            event.setCancelled(Settings.Setting.KEEP_CHUNKS_LOADED.asBoolean());
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.getBukkitEntity().getLocation().getChunk();
            return false;
        }
        boolean keepSelected = this.getTrait(Spawned.class).shouldSpawn();
        if (!keepSelected) {
            this.data().remove("selectors");
        }
        for (Trait trait : this.traits.values()) {
            trait.onDespawn();
        }
        this.getBukkitEntity().remove();
        this.mcEntity = null;
        return true;
    }

    @Override
    public LivingEntity getBukkitEntity() {
        if (this.getHandle() == null) {
            return null;
        }
        return (LivingEntity)this.getHandle().getBukkitEntity();
    }

    public EntityLiving getHandle() {
        return this.mcEntity;
    }

    @Override
    public Navigator getNavigator() {
        return this.navigator;
    }

    @Override
    public boolean isSpawned() {
        return this.mcEntity != null;
    }

    public void load(final DataKey root) {
        this.metadata.loadFrom(root.getRelative("metadata"));
        String traitNames = root.getString("traitnames");
        Iterable keys = traitNames.isEmpty() ? root.getRelative("traits").getSubKeys() : Iterables.transform((Iterable)Splitter.on((char)',').split((CharSequence)traitNames), (Function)new Function<String, DataKey>(){

            public DataKey apply(@Nullable String input) {
                return root.getRelative("traits." + input);
            }
        });
        for (DataKey traitKey : keys) {
            Trait trait;
            if (traitKey.keyExists("enabled") && !traitKey.getBoolean("enabled")) continue;
            Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(traitKey.name());
            if (this.hasTrait(clazz)) {
                trait = this.getTrait(clazz);
            } else {
                trait = CitizensAPI.getTraitFactory().getTrait(clazz);
                if (trait == null) {
                    Messaging.severeTr("citizens.notifications.skipping-broken-trait", traitKey.name(), this.getId());
                    continue;
                }
                this.addTrait(trait);
            }
            this.loadTrait(trait, traitKey);
        }
        CurrentLocation spawnLocation = this.getTrait(CurrentLocation.class);
        if (this.getTrait(Spawned.class).shouldSpawn() && spawnLocation.getLocation() != null) {
            this.spawn(spawnLocation.getLocation());
        }
        this.navigator.load(root.getRelative("navigator"));
    }

    private void loadTrait(Trait trait, DataKey traitKey) {
        try {
            trait.load(traitKey);
            PersistenceLoader.load(trait, traitKey);
        }
        catch (NPCLoadException ex) {
            Messaging.logTr("citizens.notifications.trait-load-failed", traitKey.name(), this.getId());
        }
    }

    @Override
    public void removeTrait(Class<? extends Trait> clazz) {
        Trait present = (Trait)this.traits.get(clazz);
        if (present != null) {
            this.removedTraits.add(present.getName());
        }
        super.removeTrait(clazz);
    }

    private void removeTraitData(DataKey root) {
        for (String name : this.removedTraits) {
            root.removeKey("traits." + name);
        }
        this.removedTraits.clear();
    }

    public void save(DataKey root) {
        root.setString("name", this.getFullName());
        this.metadata.saveTo(root.getRelative("metadata"));
        this.navigator.save(root.getRelative("navigator"));
        StringBuilder traitNames = new StringBuilder();
        for (Trait trait : this.traits.values()) {
            DataKey traitKey = root.getRelative("traits." + trait.getName());
            trait.save(traitKey);
            PersistenceLoader.save(trait, traitKey);
            this.removedTraits.remove(trait.getName());
            traitNames.append(trait.getName() + ",");
        }
        if (traitNames.length() > 0) {
            root.setString("traitnames", traitNames.substring(0, traitNames.length() - 1));
        }
        this.removeTraitData(root);
    }

    @Override
    public boolean spawn(Location loc) {
        boolean couldSpawn;
        Validate.notNull((Object)loc, (String)"location cannot be null");
        if (this.isSpawned()) {
            return false;
        }
        this.mcEntity = this.createHandle(loc);
        boolean bl = couldSpawn = !Util.isLoaded(loc) ? false : this.mcEntity.world.addEntity((Entity)this.mcEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        if (!couldSpawn) {
            this.mcEntity = null;
            EventListen.addForRespawn(loc, this.getId());
            return true;
        }
        NPCSpawnEvent spawnEvent = new NPCSpawnEvent(this, loc);
        Bukkit.getPluginManager().callEvent((Event)spawnEvent);
        if (spawnEvent.isCancelled()) {
            this.mcEntity = null;
            return false;
        }
        NMS.setHeadYaw(this.mcEntity, loc.getYaw());
        this.getBukkitEntity().setMetadata(NPC_METADATA_MARKER, (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)true));
        this.getTrait(CurrentLocation.class).setLocation(loc);
        this.getTrait(Spawned.class).setSpawned(true);
        this.navigator.onSpawn();
        for (Trait trait : this.traits.values()) {
            trait.onSpawn();
        }
        return true;
    }

    @Override
    public void update() {
        try {
            super.update();
            if (this.isSpawned()) {
                NMS.trySwim(this.getHandle());
            }
        }
        catch (Exception ex) {
            Messaging.logTr("citizens.notifications.exception-updating-npc", this.getId(), ex.getMessage());
            ex.printStackTrace();
        }
    }
}

