/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.OpenDoorCallback;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import org.bukkit.Material;
import org.bukkit.util.Vector;

public class MinecraftBlockExaminer
implements BlockExaminer {
    private static final float[] COSTS = new float[16];
    private static final Vector DOWN = new Vector(0, -1, 0);
    private static final Set<Material> PASSABLE = EnumSet.of(Material.AIR, new Material[]{Material.DEAD_BUSH, Material.DETECTOR_RAIL, Material.DIODE, Material.DIODE_BLOCK_OFF, Material.DIODE_BLOCK_ON, Material.FENCE_GATE, Material.ITEM_FRAME, Material.LADDER, Material.LEVER, Material.LONG_GRASS, Material.MELON_STEM, Material.NETHER_FENCE, Material.PUMPKIN_STEM, Material.POWERED_RAIL, Material.RAILS, Material.RED_ROSE, Material.RED_MUSHROOM, Material.REDSTONE, Material.REDSTONE_TORCH_OFF, Material.REDSTONE_TORCH_OFF, Material.REDSTONE_WIRE, Material.SIGN, Material.SIGN_POST, Material.SNOW, Material.STRING, Material.STONE_BUTTON, Material.SUGAR_CANE_BLOCK, Material.TRIPWIRE, Material.VINE, Material.WALL_SIGN, Material.WHEAT, Material.WATER, Material.WEB, Material.WOOD_BUTTON, Material.WOODEN_DOOR, Material.STATIONARY_WATER});
    private static final Set<Material> UNWALKABLE = Sets.union(PASSABLE, EnumSet.of(Material.AIR, Material.LAVA, Material.STATIONARY_LAVA, Material.CACTUS));
    private static final Vector UP = new Vector(0, 1, 0);

    private boolean canStandIn(Material mat) {
        return PASSABLE.contains(mat);
    }

    private boolean canStandOn(Material mat) {
        return !UNWALKABLE.contains(mat);
    }

    private boolean contains(Material[] search, Material ... find) {
        for (Material haystack : search) {
            for (Material needle : find) {
                if (haystack != needle) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        Material above = source.getMaterialAt(pos.clone().add(UP));
        Material below = source.getMaterialAt(pos.clone().add(DOWN));
        Material in = source.getMaterialAt(pos);
        if (above == Material.WEB || in == Material.WEB) {
            return 1.0f;
        }
        if (below == Material.SOUL_SAND || below == Material.ICE) {
            return 1.0f;
        }
        if (this.isLiquid(above, below, in)) {
            return 0.5f;
        }
        if (this.isDoor(above, below)) {
            point.addCallback(new OpenDoorCallback());
        }
        return 0.5f - COSTS[source.getLightLevel(pos)];
    }

    private boolean isDoor(Material ... below) {
        return this.contains(below, Material.WOOD_DOOR);
    }

    private boolean isLiquid(Material ... materials) {
        return this.contains(materials, Material.WATER, Material.STATIONARY_WATER, Material.LAVA, Material.STATIONARY_LAVA);
    }

    @Override
    public boolean isPassable(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        Material above = source.getMaterialAt(pos.clone().add(UP));
        Material below = source.getMaterialAt(pos.clone().add(DOWN));
        Material in = source.getMaterialAt(pos);
        if (!below.isBlock() || !this.canStandOn(below)) {
            return false;
        }
        return this.canStandIn(above) && this.canStandIn(in);
    }

    static {
        float f = 0.0f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            MinecraftBlockExaminer.COSTS[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
    }
}

