/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.ChunkBlockSource;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.VectorGoal;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.AbstractPathStrategy;
import net.citizensnpcs.util.NMS;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class AStarNavigationStrategy
extends AbstractPathStrategy {
    private final Location dest;
    private final CitizensNPC npc;
    private final NavigatorParameters params;
    private Path plan;
    private Vector vector;
    private static final AStarMachine ASTAR = AStarMachine.createWithDefaultStorage();

    AStarNavigationStrategy(CitizensNPC npc, Location dest, NavigatorParameters params) {
        super(TargetType.LOCATION);
        this.params = params;
        this.dest = dest;
        this.npc = npc;
        Location location = npc.getBukkitEntity().getEyeLocation();
        this.plan = (Path)ASTAR.runFully(new VectorGoal(dest), new VectorNode(location, (BlockSource)new ChunkBlockSource(location, params.range()), params.examiners()), (int)(params.range() * 10.0f));
        if (this.plan == null || this.plan.isComplete()) {
            this.setCancelReason(CancelReason.STUCK);
        } else {
            this.vector = this.plan.getCurrentVector();
        }
    }

    @Override
    public Location getTargetAsLocation() {
        return this.dest;
    }

    @Override
    public void stop() {
        this.plan = null;
    }

    @Override
    public boolean update() {
        if (this.getCancelReason() != null) {
            return true;
        }
        if (this.plan == null || this.plan.isComplete()) {
            return true;
        }
        if (this.npc.getBukkitEntity().getVelocity().distanceSquared(this.vector) <= this.params.distanceMargin()) {
            this.plan.update(this.npc);
            if (this.plan.isComplete()) {
                return true;
            }
            this.vector = this.plan.getCurrentVector();
        }
        NMS.setDestination(this.npc.getBukkitEntity(), this.vector.getX(), this.vector.getY(), this.vector.getZ(), this.params.speed());
        return false;
    }
}

