/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.command.command;

import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.command.Command;
import net.citizensnpcs.command.CommandContext;
import net.citizensnpcs.command.Requirements;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.Messaging;
import org.bukkit.command.CommandSender;

@Requirements(ownership=true, selected=true)
public class WaypointCommands {
    public WaypointCommands(Citizens plugin) {
    }

    @Command(aliases={"waypoints", "waypoint", "wp"}, usage="disableteleporting", desc="Disables teleportation when stuck (temporary command)", modifiers={"disableteleport"}, min=1, max=1, permission="waypoints.disableteleport")
    public void disableTeleporting(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        npc.getNavigator().getDefaultParameters().stuckAction(null);
        Messaging.sendTr(sender, "citizens.commands.waypoints.disableteleporting.disabled", new Object[0]);
    }

    @Command(aliases={"waypoints", "waypoint", "wp"}, usage="provider [provider name] (-a)", desc="Sets the current waypoint provider", modifiers={"provider"}, min=1, max=2, flags="a", permission="waypoints.provider")
    public void provider(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Waypoints waypoints = npc.getTrait(Waypoints.class);
        if (args.argsLength() == 1) {
            if (args.hasFlag('a')) {
                waypoints.describeProviders(sender);
            } else {
                Messaging.sendTr(sender, "citizens.waypoints.current-provider", waypoints.getCurrentProviderName());
            }
            return;
        }
        boolean success = waypoints.setWaypointProvider(args.getString(1));
        if (!success) {
            throw new CommandException("Provider not found.");
        }
        Messaging.sendTr(sender, "citizens.waypoints.set-provider", args.getString(1));
    }
}

