/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.editor;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.editor.EndermanEquipper;
import net.citizensnpcs.editor.Equipper;
import net.citizensnpcs.editor.GenericEquipper;
import net.citizensnpcs.editor.PigEquipper;
import net.citizensnpcs.editor.SheepEquipper;
import net.citizensnpcs.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class EquipmentEditor
extends Editor {
    private final NPC npc;
    private final Player player;
    private static final Map<EntityType, Equipper> EQUIPPERS = Maps.newEnumMap(EntityType.class);

    public EquipmentEditor(Player player, NPC npc) {
        this.player = player;
        this.npc = npc;
    }

    @Override
    public void begin() {
        Messaging.sendTr((CommandSender)this.player, "citizens.editors.equipment.begin", new Object[0]);
    }

    @Override
    public void end() {
        Messaging.sendTr((CommandSender)this.player, "citizens.editors.equipment.end", new Object[0]);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_AIR && Editor.hasEditor(event.getPlayer())) {
            event.setUseItemInHand(Event.Result.DENY);
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!(this.npc.isSpawned() && event.getPlayer().equals(this.player) && this.npc.equals(CitizensAPI.getNPCRegistry().getNPC(event.getRightClicked())))) {
            return;
        }
        Equipper equipper = EQUIPPERS.get(this.npc.getBukkitEntity().getType());
        if (equipper == null) {
            equipper = new GenericEquipper();
        }
        equipper.equip(event.getPlayer(), this.npc);
    }

    static {
        EQUIPPERS.put(EntityType.PIG, new PigEquipper());
        EQUIPPERS.put(EntityType.SHEEP, new SheepEquipper());
        EQUIPPERS.put(EntityType.ENDERMAN, new EndermanEquipper());
    }
}

