/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.citizensnpcs.EventListen;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.EntityController;
import net.citizensnpcs.npc.ai.CitizensNavigator;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_4_6.Entity;
import net.minecraft.server.v1_4_6.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_4_6.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class CitizensNPC
extends AbstractNPC {
    private EntityController entityController;
    private final CitizensNavigator navigator = new CitizensNavigator(this);
    private final List<String> removedTraits = Lists.newArrayList();
    private static final String NPC_METADATA_MARKER = "NPC";

    public CitizensNPC(int id, String name, EntityController entityController) {
        super(id, name);
        Preconditions.checkNotNull((Object)entityController);
        this.entityController = entityController;
    }

    @Override
    public boolean despawn(DespawnReason reason) {
        if (!this.isSpawned()) {
            return false;
        }
        NPCDespawnEvent event = new NPCDespawnEvent(this, reason);
        if (reason == DespawnReason.CHUNK_UNLOAD) {
            event.setCancelled(Settings.Setting.KEEP_CHUNKS_LOADED.asBoolean());
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.getBukkitEntity().getLocation().getChunk().load();
            return false;
        }
        boolean keepSelected = this.getTrait(Spawned.class).shouldSpawn();
        if (!keepSelected) {
            this.data().remove("selectors");
        }
        for (Trait trait : this.traits.values()) {
            trait.onDespawn();
        }
        this.entityController.remove();
        return true;
    }

    @Override
    public LivingEntity getBukkitEntity() {
        return this.entityController.getBukkitEntity();
    }

    @Deprecated
    public EntityLiving getHandle() {
        return ((CraftLivingEntity)this.getBukkitEntity()).getHandle();
    }

    @Override
    public Navigator getNavigator() {
        return this.navigator;
    }

    @Override
    public boolean isSpawned() {
        return this.getBukkitEntity() != null;
    }

    public void load(final DataKey root) {
        this.metadata.loadFrom(root.getRelative("metadata"));
        String traitNames = root.getString("traitnames");
        Iterable keys = traitNames.isEmpty() ? root.getRelative("traits").getSubKeys() : Iterables.transform((Iterable)Splitter.on((char)',').split((CharSequence)traitNames), (Function)new Function<String, DataKey>(){

            public DataKey apply(@Nullable String input) {
                return root.getRelative("traits." + input);
            }
        });
        for (DataKey traitKey : keys) {
            Trait trait;
            if (traitKey.keyExists("enabled") && !traitKey.getBoolean("enabled")) continue;
            Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(traitKey.name());
            if (this.hasTrait(clazz)) {
                trait = this.getTrait(clazz);
            } else {
                trait = CitizensAPI.getTraitFactory().getTrait(clazz);
                if (trait == null) {
                    Messaging.severeTr("citizens.notifications.skipping-broken-trait", traitKey.name(), this.getId());
                    continue;
                }
                this.addTrait(trait);
            }
            this.loadTrait(trait, traitKey);
        }
        CurrentLocation spawnLocation = this.getTrait(CurrentLocation.class);
        if (this.getTrait(Spawned.class).shouldSpawn() && spawnLocation.getLocation() != null) {
            this.spawn(spawnLocation.getLocation());
        }
        this.navigator.load(root.getRelative("navigator"));
    }

    private void loadTrait(Trait trait, DataKey traitKey) {
        try {
            trait.load(traitKey);
            PersistenceLoader.load(trait, traitKey);
        }
        catch (Throwable ex) {
            Messaging.logTr("citizens.notifications.trait-load-failed", traitKey.name(), this.getId());
        }
    }

    @Override
    public void removeTrait(Class<? extends Trait> clazz) {
        Trait present = (Trait)this.traits.get(clazz);
        if (present != null) {
            this.removedTraits.add(present.getName());
        }
        super.removeTrait(clazz);
    }

    private void removeTraitData(DataKey root) {
        for (String name : this.removedTraits) {
            root.removeKey("traits." + name);
        }
        this.removedTraits.clear();
    }

    public void save(DataKey root) {
        root.setString("name", this.getFullName());
        this.metadata.saveTo(root.getRelative("metadata"));
        this.navigator.save(root.getRelative("navigator"));
        StringBuilder traitNames = new StringBuilder();
        for (Trait trait : this.traits.values()) {
            DataKey traitKey = root.getRelative("traits." + trait.getName());
            trait.save(traitKey);
            PersistenceLoader.save(trait, traitKey);
            this.removedTraits.remove(trait.getName());
            traitNames.append(trait.getName() + ",");
        }
        if (traitNames.length() > 0) {
            root.setString("traitnames", traitNames.substring(0, traitNames.length() - 1));
        }
        this.removeTraitData(root);
    }

    public void setEntityController(EntityController newController) {
        Preconditions.checkNotNull((Object)newController);
        boolean wasSpawned = this.isSpawned();
        Location prev = null;
        if (wasSpawned) {
            prev = this.getBukkitEntity().getLocation();
            this.despawn();
        }
        this.entityController = newController;
        if (wasSpawned) {
            this.spawn(prev);
        }
    }

    @Override
    public boolean spawn(Location at) {
        boolean couldSpawn;
        Preconditions.checkNotNull((Object)at, (Object)"location cannot be null");
        if (this.isSpawned()) {
            return false;
        }
        this.entityController.spawn(at, this);
        EntityLiving mcEntity = this.getHandle();
        boolean bl = couldSpawn = !Util.isLoaded(at) ? false : mcEntity.world.addEntity((Entity)mcEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        if (!couldSpawn) {
            mcEntity = null;
            EventListen.addForRespawn(at, this.getId());
            return true;
        }
        NPCSpawnEvent spawnEvent = new NPCSpawnEvent(this, at);
        Bukkit.getPluginManager().callEvent((Event)spawnEvent);
        if (spawnEvent.isCancelled()) {
            mcEntity = null;
            return false;
        }
        NMS.setHeadYaw(mcEntity, at.getYaw());
        this.getBukkitEntity().setMetadata(NPC_METADATA_MARKER, (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)true));
        this.getTrait(CurrentLocation.class).setLocation(at);
        this.getTrait(Spawned.class).setSpawned(true);
        this.navigator.onSpawn();
        for (Trait trait : this.traits.values()) {
            trait.onSpawn();
        }
        this.getBukkitEntity().setRemoveWhenFarAway(false);
        return true;
    }

    @Override
    public void update() {
        try {
            super.update();
            if (this.isSpawned()) {
                NMS.trySwim(this.getBukkitEntity());
                this.navigator.run();
            }
        }
        catch (Exception ex) {
            Messaging.logTr("citizens.notifications.exception-updating-npc", this.getId(), ex.getMessage());
            ex.printStackTrace();
        }
    }
}

