/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import com.google.common.collect.Lists;
import java.util.List;
import net.citizensnpcs.api.ai.AttackStrategy;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;

public class NavigatorParameters
implements Cloneable {
    private AttackStrategy attackStrategy;
    private boolean avoidWater;
    private float baseSpeed;
    private double distanceMargin = 3.0;
    private final List<BlockExaminer> examiners = Lists.newArrayList();
    private float range;
    private float speedModifier = 1.0f;
    private int stationaryTicks = -1;
    private StuckAction stuckAction;

    public AttackStrategy attackStrategy() {
        return this.attackStrategy;
    }

    public void attackStrategy(AttackStrategy strategy) {
        this.attackStrategy = strategy;
    }

    public boolean avoidWater() {
        return this.avoidWater;
    }

    public NavigatorParameters avoidWater(boolean avoidWater) {
        this.avoidWater = avoidWater;
        return this;
    }

    public float baseSpeed() {
        return this.baseSpeed;
    }

    public NavigatorParameters baseSpeed(float speed) {
        this.baseSpeed = speed;
        return this;
    }

    public NavigatorParameters clearExaminers() {
        this.examiners.clear();
        return this;
    }

    public NavigatorParameters clone() {
        try {
            return (NavigatorParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public double distanceMargin() {
        return this.distanceMargin;
    }

    public NavigatorParameters distanceMargin(double newMargin) {
        this.distanceMargin = newMargin;
        return this;
    }

    public NavigatorParameters examiner(BlockExaminer examiner) {
        this.examiners.add(examiner);
        return this;
    }

    public BlockExaminer[] examiners() {
        return this.examiners.toArray(new BlockExaminer[this.examiners.size()]);
    }

    public float modifiedSpeed(float toModify) {
        return toModify * this.speedModifier();
    }

    public float range() {
        return this.range;
    }

    public NavigatorParameters range(float range) {
        this.range = range;
        return this;
    }

    public float speed() {
        return this.modifiedSpeed(this.baseSpeed);
    }

    @Deprecated
    public NavigatorParameters speed(float speed) {
        this.baseSpeed = speed;
        return this;
    }

    public float speedModifier() {
        return this.speedModifier;
    }

    public NavigatorParameters speedModifier(float percent) {
        this.speedModifier = percent;
        return this;
    }

    public int stationaryTicks() {
        return this.stationaryTicks;
    }

    public NavigatorParameters stationaryTicks(int ticks) {
        this.stationaryTicks = ticks;
        return this;
    }

    public StuckAction stuckAction() {
        return this.stuckAction;
    }

    public NavigatorParameters stuckAction(StuckAction action) {
        this.stuckAction = action;
        return this;
    }
}

