/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.scripting;

import com.google.common.base.Throwables;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import net.citizensnpcs.api.scripting.ContextProvider;
import net.citizensnpcs.api.scripting.Script;
import net.citizensnpcs.api.scripting.ScriptFactory;
import net.citizensnpcs.api.scripting.SimpleScript;

public class SimpleScriptFactory
implements ScriptFactory {
    private final ContextProvider[] providers;
    private final CompiledScript src;

    SimpleScriptFactory(CompiledScript src, ContextProvider ... providers) {
        if (src == null) {
            throw new IllegalArgumentException("src cannot be null");
        }
        if (providers == null) {
            providers = new ContextProvider[]{};
        }
        this.src = src;
        this.providers = providers;
    }

    @Override
    public Script newInstance() {
        try {
            return new SimpleScript(this.src, this.providers);
        }
        catch (ScriptException e) {
            Throwables.getRootCause((Throwable)e).printStackTrace();
            return null;
        }
    }
}

