/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.ChunkBlockSource;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.VectorGoal;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.AbstractPathStrategy;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_4_6.EntityLiving;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class AStarNavigationStrategy
extends AbstractPathStrategy {
    private final Location destination;
    private final NPC npc;
    private final NavigatorParameters params;
    private Path plan;
    private Vector vector;
    private static final AStarMachine<VectorNode, Path> ASTAR = AStarMachine.createWithDefaultStorage();
    private static final Location NPC_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    AStarNavigationStrategy(NPC npc, Location dest, NavigatorParameters params) {
        super(TargetType.LOCATION);
        this.params = params;
        this.destination = dest;
        this.npc = npc;
        Location location = npc.getBukkitEntity().getEyeLocation();
        this.plan = ASTAR.runFully(new VectorGoal(dest), new VectorNode(location, (BlockSource)new ChunkBlockSource(location, params.range()), params.examiners()), (int)(params.range() * 10.0f));
        if (this.plan == null || this.plan.isComplete()) {
            this.setCancelReason(CancelReason.STUCK);
        } else {
            this.vector = this.plan.getCurrentVector();
        }
    }

    @Override
    public Location getTargetAsLocation() {
        return this.destination;
    }

    @Override
    public void stop() {
        this.plan = null;
    }

    @Override
    public boolean update() {
        double dY;
        double dZ;
        if (this.getCancelReason() != null || this.plan == null || this.plan.isComplete()) {
            return true;
        }
        if (this.npc.getBukkitEntity().getLocation(NPC_LOCATION).toVector().distanceSquared(this.vector) <= this.params.distanceMargin()) {
            this.plan.update(this.npc);
            if (this.plan.isComplete()) {
                return true;
            }
            this.vector = this.plan.getCurrentVector();
            World world = this.npc.getBukkitEntity().getWorld();
            world.playEffect(this.vector.toLocation(world), Effect.STEP_SOUND, Material.STONE.getId());
        }
        EntityLiving handle = NMS.getHandle(this.npc.getBukkitEntity());
        double dX = (double)this.vector.getBlockX() - handle.locX;
        double xzDistance = dX * dX + (dZ = (double)this.vector.getBlockZ() - handle.locZ) * dZ;
        double distance = xzDistance + (dY = this.vector.getY() - handle.locY) * dY;
        if (distance >= 1.0E-5 && dY > 0.0 && xzDistance <= 2.75) {
            NMS.setShouldJump(this.npc.getBukkitEntity());
        }
        NMS.setDestination(this.npc.getBukkitEntity(), this.vector.getX(), this.vector.getY(), this.vector.getZ(), this.params.speed());
        return false;
    }
}

