/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api;

import java.io.File;
import net.citizensnpcs.api.CitizensPlugin;
import net.citizensnpcs.api.ai.speech.SpeechFactory;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.scripting.ScriptCompiler;
import net.citizensnpcs.api.trait.TraitFactory;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class CitizensAPI {
    private CitizensPlugin implementation;
    private static final CitizensAPI instance = new CitizensAPI();
    private static ScriptCompiler scriptCompiler;

    private CitizensAPI() {
    }

    public static File getDataFolder() {
        return CitizensAPI.getImplementation().getDataFolder();
    }

    private static CitizensPlugin getImplementation() {
        if (CitizensAPI.instance.implementation == null) {
            throw new IllegalStateException("no implementation set");
        }
        return CitizensAPI.instance.implementation;
    }

    public static NPCRegistry getNPCRegistry() {
        return CitizensAPI.getImplementation().getNPCRegistry();
    }

    public static Plugin getPlugin() {
        return CitizensAPI.getImplementation();
    }

    public static ScriptCompiler getScriptCompiler() {
        if (scriptCompiler == null) {
            scriptCompiler = new ScriptCompiler();
            scriptCompiler.start();
        }
        return scriptCompiler;
    }

    public static File getScriptFolder() {
        return CitizensAPI.getImplementation().getScriptFolder();
    }

    public static SpeechFactory getSpeechFactory() {
        return CitizensAPI.getImplementation().getSpeechFactory();
    }

    public static TraitFactory getTraitFactory() {
        return CitizensAPI.getImplementation().getTraitFactory();
    }

    public static boolean hasImplementation() {
        return CitizensAPI.instance.implementation != null;
    }

    public static void registerEvents(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, CitizensAPI.getPlugin());
    }

    public static void setImplementation(CitizensPlugin implementation) {
        if (implementation != null && CitizensAPI.hasImplementation()) {
            CitizensAPI.getImplementation().onImplementationChanged();
        }
        CitizensAPI.instance.implementation = implementation;
    }

    public static void shutdown() {
        if (scriptCompiler == null) {
            return;
        }
        CitizensAPI.instance.implementation = null;
        scriptCompiler.interrupt();
        scriptCompiler = null;
    }
}

