/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_4_6.EntityLiving;
import net.minecraft.server.v1_4_6.EntitySilverfish;
import net.minecraft.server.v1_4_6.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_4_6.CraftServer;
import org.bukkit.craftbukkit.v1_4_6.entity.CraftSilverfish;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Silverfish;
import org.bukkit.util.Vector;

public class SilverfishController
extends MobEntityController {
    public SilverfishController() {
        super(EntitySilverfishNPC.class);
    }

    public Silverfish getBukkitEntity() {
        return (Silverfish)super.getBukkitEntity();
    }

    public static class SilverfishNPC
    extends CraftSilverfish
    implements NPCHolder {
        private final CitizensNPC npc;

        public SilverfishNPC(EntitySilverfishNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntitySilverfish)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntitySilverfishNPC
    extends EntitySilverfish
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntitySilverfishNPC(World world) {
            this(world, null);
        }

        public EntitySilverfishNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        public void bl() {
            super.bl();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public void bn() {
            if (this.npc == null) {
                super.bn();
            } else {
                NMS.updateAI((EntityLiving)this);
                this.npc.update();
            }
        }

        public void collide(net.minecraft.server.v1_4_6.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, entity.getBukkitEntity());
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public Entity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new SilverfishNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

