/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.Composite;

public class Sequence
extends Composite {
    private Behavior executing;
    private int executingIndex;
    private final boolean retryChildren;

    private Sequence(boolean retryChildren, Behavior ... behaviors) {
        this(retryChildren, Arrays.asList(behaviors));
    }

    private Sequence(boolean retryChildren, Collection<Behavior> behaviors) {
        super(behaviors);
        this.retryChildren = retryChildren;
    }

    @Override
    public void reset() {
        if (this.executing != null) {
            this.executing.reset();
        }
        this.executing = null;
        this.executingIndex = 0;
    }

    @Override
    public BehaviorStatus run() {
        List<Behavior> behaviors = this.getBehaviors();
        if (this.executing == null) {
            this.executing = behaviors.get(this.executingIndex);
            if (!this.executing.shouldExecute()) {
                if (this.retryChildren) {
                    this.executing = null;
                    return BehaviorStatus.RUNNING;
                }
                return BehaviorStatus.FAILURE;
            }
        }
        BehaviorStatus status = this.executing.run();
        switch (status) {
            case RUNNING: {
                return BehaviorStatus.RUNNING;
            }
            case FAILURE: {
                if (!this.retryChildren) {
                    return BehaviorStatus.FAILURE;
                }
                this.executing = null;
                return BehaviorStatus.RUNNING;
            }
            case SUCCESS: {
                ++this.executingIndex;
                if (this.executingIndex >= behaviors.size()) {
                    return BehaviorStatus.SUCCESS;
                }
                this.executing = behaviors.get(this.executingIndex);
                if (!this.executing.shouldExecute() && !this.retryChildren) {
                    return BehaviorStatus.FAILURE;
                }
                return BehaviorStatus.RUNNING;
            }
        }
        throw new IllegalStateException();
    }

    public static Sequence createRetryingSequence(Behavior ... behaviors) {
        return Sequence.createRetryingSequence(Arrays.asList(behaviors));
    }

    public static Sequence createRetryingSequence(Collection<Behavior> behaviors) {
        return new Sequence(true, behaviors);
    }

    public static Sequence createSequence(Behavior ... behaviors) {
        return Sequence.createSequence(Arrays.asList(behaviors));
    }

    public static Sequence createSequence(Collection<Behavior> behaviors) {
        return new Sequence(false, behaviors);
    }
}

