/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_4_R1.Entity;
import net.minecraft.server.v1_4_R1.EntityPlayer;
import net.minecraft.server.v1_4_R1.Packet;
import net.minecraft.server.v1_4_R1.Packet17EntityLocationAction;
import net.minecraft.server.v1_4_R1.Packet18ArmAnimation;
import net.minecraft.server.v1_4_R1.Packet40EntityMetadata;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public enum PlayerAnimation {
    ARM_SWING{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            Packet18ArmAnimation packet = new Packet18ArmAnimation((Entity)player, 1);
            this.sendPacketNearby((Packet)packet, player, radius);
        }
    }
    ,
    HURT{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            Packet18ArmAnimation packet = new Packet18ArmAnimation((Entity)player, 2);
            this.sendPacketNearby((Packet)packet, player, radius);
        }
    }
    ,
    SIT{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            player.mount((Entity)player);
        }
    }
    ,
    SLEEP{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            Packet17EntityLocationAction packet = new Packet17EntityLocationAction((Entity)player, 0, (int)player.locX, (int)player.locY, (int)player.locZ);
            this.sendPacketNearby((Packet)packet, player, radius);
        }
    }
    ,
    SNEAK{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            player.getBukkitEntity().setSneaking(true);
            this.sendPacketNearby((Packet)new Packet40EntityMetadata(player.id, player.getDataWatcher(), true), player, radius);
        }
    }
    ,
    STOP_SITTING{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            player.mount(null);
        }
    }
    ,
    STOP_SLEEPING{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            Packet18ArmAnimation packet = new Packet18ArmAnimation((Entity)player, 3);
            this.sendPacketNearby((Packet)packet, player, radius);
        }
    }
    ,
    STOP_SNEAKING{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            player.getBukkitEntity().setSneaking(false);
            this.sendPacketNearby((Packet)new Packet40EntityMetadata(player.id, player.getDataWatcher(), true), player, radius);
        }
    };


    public void play(Player player) {
        this.play(player, 64);
    }

    public void play(Player player, int radius) {
        this.playAnimation(((CraftPlayer)player).getHandle(), radius);
    }

    protected void playAnimation(EntityPlayer player, int radius) {
        throw new UnsupportedOperationException("unimplemented animation");
    }

    protected void sendPacketNearby(Packet packet, EntityPlayer player, int radius) {
        NMS.sendPacketNearby(player.getBukkitEntity().getLocation(), packet, radius);
    }
}

