/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.command;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.EnumSet;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.command.CommandAnnotationProcessor;
import net.citizensnpcs.command.CommandContext;
import net.citizensnpcs.command.Requirements;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.command.exception.RequirementMissingException;
import net.citizensnpcs.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;

public class RequirementsProcessor
implements CommandAnnotationProcessor {
    @Override
    public Class<? extends Annotation> getAnnotationClass() {
        return Requirements.class;
    }

    @Override
    public void process(CommandSender sender, CommandContext context, Annotation instance, Object[] methodArgs) throws CommandException {
        NPC npc;
        Requirements requirements = (Requirements)instance;
        NPC nPC = npc = methodArgs.length >= 3 && methodArgs[2] instanceof NPC ? (NPC)methodArgs[2] : null;
        if (requirements.selected()) {
            boolean canRedefineSelected = context.hasValueFlag("id") && sender.hasPermission("npc.select");
            String error = Messaging.tr("citizens.commands.requirements.must-have-selected", new Object[0]);
            if (canRedefineSelected && (npc = CitizensAPI.getNPCRegistry().getById(context.getFlagInteger("id"))) == null) {
                error = error + ' ' + Messaging.tr("citizens.commands.id-not-found", context.getFlagInteger("id"));
            }
            if (npc == null) {
                throw new RequirementMissingException(error);
            }
        }
        if (requirements.ownership() && npc != null && !sender.hasPermission("citizens.admin") && !npc.getTrait(Owner.class).isOwnedBy(sender)) {
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.must-be-owner", new Object[0]));
        }
        if (npc == null) {
            return;
        }
        for (Class<? extends Trait> clazz : requirements.traits()) {
            if (npc.hasTrait(clazz)) continue;
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.missing-required-trait", clazz.getSimpleName()));
        }
        EnumSet<EntityType> types = Sets.newEnumSet(Arrays.asList(requirements.types()), EntityType.class);
        if (types.contains(EntityType.UNKNOWN)) {
            types = EnumSet.allOf(EntityType.class);
        }
        types.removeAll(Sets.newHashSet((Object[])requirements.excludedTypes()));
        EntityType type = npc.getTrait(MobType.class).getType();
        if (!types.contains(type)) {
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.disallowed-mobtype", type.getName()));
        }
    }
}

