/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_4_R1.EntitySheep;
import net.minecraft.server.v1_4_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_4_R1.CraftServer;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftSheep;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Sheep;
import org.bukkit.util.Vector;

public class SheepController
extends MobEntityController {
    public SheepController() {
        super(EntitySheepNPC.class);
    }

    public Sheep getBukkitEntity() {
        return (Sheep)super.getBukkitEntity();
    }

    public static class SheepNPC
    extends CraftSheep
    implements NPCHolder {
        private final CitizensNPC npc;

        public SheepNPC(EntitySheepNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntitySheep)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntitySheepNPC
    extends EntitySheep
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntitySheepNPC(World world) {
            this(world, null);
        }

        public EntitySheepNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        public void bl() {
            super.bl();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public void collide(net.minecraft.server.v1_4_R1.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new SheepNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

