/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import net.citizensnpcs.EventListen;
import net.citizensnpcs.Metrics;
import net.citizensnpcs.NPCDataStore;
import net.citizensnpcs.PaymentListener;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.CitizensPlugin;
import net.citizensnpcs.api.ai.speech.SpeechFactory;
import net.citizensnpcs.api.event.CitizensDisableEvent;
import net.citizensnpcs.api.event.CitizensEnableEvent;
import net.citizensnpcs.api.event.CitizensReloadEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.scripting.EventRegistrar;
import net.citizensnpcs.api.scripting.ObjectProvider;
import net.citizensnpcs.api.scripting.ScriptCompiler;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitFactory;
import net.citizensnpcs.api.util.Translator;
import net.citizensnpcs.command.CommandContext;
import net.citizensnpcs.command.CommandManager;
import net.citizensnpcs.command.Injector;
import net.citizensnpcs.command.RequirementsProcessor;
import net.citizensnpcs.command.command.AdminCommands;
import net.citizensnpcs.command.command.EditorCommands;
import net.citizensnpcs.command.command.HelpCommands;
import net.citizensnpcs.command.command.NPCCommands;
import net.citizensnpcs.command.command.ScriptCommands;
import net.citizensnpcs.command.command.TemplateCommands;
import net.citizensnpcs.command.command.TraitCommands;
import net.citizensnpcs.command.command.WaypointCommands;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.CitizensNPCRegistry;
import net.citizensnpcs.npc.CitizensTraitFactory;
import net.citizensnpcs.npc.NPCSelector;
import net.citizensnpcs.npc.ai.speech.Chat;
import net.citizensnpcs.npc.ai.speech.CitizensSpeechFactory;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.StringHelper;
import net.citizensnpcs.util.Util;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Citizens
extends JavaPlugin
implements CitizensPlugin {
    private final CommandManager commands = new CommandManager();
    private boolean compatible;
    private Settings config;
    private CitizensNPCRegistry npcRegistry;
    private NPCDataStore saves;
    private NPCSelector selector;
    private CitizensSpeechFactory speechFactory;
    private CitizensTraitFactory traitFactory;
    private static final String COMPATIBLE_MC_VERSION = "1.4.7";

    private void despawnNPCs() {
        Iterator<NPC> itr = this.npcRegistry.iterator();
        while (itr.hasNext()) {
            NPC npc = itr.next();
            try {
                npc.despawn();
                for (Trait trait : npc.getTraits()) {
                    trait.onRemove();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            itr.remove();
        }
    }

    private void enableSubPlugins() {
        File[] files;
        File root = new File(this.getDataFolder(), Settings.Setting.SUBPLUGIN_FOLDER.asString());
        if (!root.exists() || !root.isDirectory()) {
            return;
        }
        for (File file : files = root.listFiles()) {
            Plugin plugin;
            try {
                plugin = Bukkit.getPluginManager().loadPlugin(file);
            }
            catch (Exception e) {
                continue;
            }
            if (plugin == null) continue;
            try {
                Messaging.logTr("citizens.sub-plugins.load", plugin.getDescription().getFullName());
                plugin.onLoad();
            }
            catch (Throwable ex) {
                Messaging.severeTr("citizens.sub-plugins.error-on-load", ex.getMessage(), plugin.getDescription().getFullName());
                ex.printStackTrace();
            }
        }
        NMS.loadPlugins();
    }

    public CommandManager.CommandInfo getCommandInfo(String rootCommand, String modifier) {
        return this.commands.getCommand(rootCommand, modifier);
    }

    public Iterable<CommandManager.CommandInfo> getCommands(String base) {
        return this.commands.getCommands(base);
    }

    @Override
    public NPCRegistry getNPCRegistry() {
        return this.npcRegistry;
    }

    public NPCSelector getNPCSelector() {
        return this.selector;
    }

    @Override
    public File getScriptFolder() {
        return new File(this.getDataFolder(), "scripts");
    }

    @Override
    public SpeechFactory getSpeechFactory() {
        return this.speechFactory;
    }

    @Override
    public TraitFactory getTraitFactory() {
        return this.traitFactory;
    }

    public boolean onCommand(CommandSender sender, Command command, String cmdName, String[] args) {
        String modifier;
        String string = modifier = args.length > 0 ? args[0] : "";
        if (!this.commands.hasCommand(command, modifier) && !modifier.isEmpty()) {
            return this.suggestClosestModifier(sender, command.getName(), modifier);
        }
        NPC npc = this.selector == null ? null : this.selector.getSelected(sender);
        Object[] methodArgs = new Object[]{sender, npc};
        return this.commands.executeSafe(command, args, sender, methodArgs);
    }

    public void onDisable() {
        Bukkit.getPluginManager().callEvent((Event)new CitizensDisableEvent());
        Editor.leaveAll();
        CitizensAPI.shutdown();
        if (this.compatible) {
            this.saves.storeAll(this.npcRegistry);
            this.saves.saveToDiskImmediate();
            this.despawnNPCs();
            this.npcRegistry = null;
        }
    }

    public void onEnable() {
        this.setupTranslator();
        CitizensAPI.setImplementation(this);
        String mcVersion = Util.getMinecraftVersion();
        this.compatible = mcVersion.startsWith(COMPATIBLE_MC_VERSION);
        if (!this.compatible) {
            Messaging.severeTr("citizens.notifications.incompatible-version", this.getDescription().getVersion(), mcVersion);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.config = new Settings(this.getDataFolder());
        this.registerScriptHelpers();
        this.saves = NPCDataStore.create(this.getDataFolder());
        if (this.saves == null) {
            Messaging.severeTr("citizens.saves.load-failed", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.npcRegistry = new CitizensNPCRegistry(this.saves);
        this.traitFactory = new CitizensTraitFactory();
        this.selector = new NPCSelector(this);
        this.speechFactory = new CitizensSpeechFactory();
        this.speechFactory.register(Chat.class, "chat");
        this.getServer().getPluginManager().registerEvents((Listener)new EventListen(), (Plugin)this);
        if (Settings.Setting.NPC_COST.asDouble() > 0.0) {
            this.setupEconomy();
        }
        this.registerCommands();
        this.enableSubPlugins();
        if (this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Citizens.this.saves.loadInto(Citizens.this.npcRegistry);
                Citizens.this.startMetrics();
                Citizens.this.scheduleSaveTask(Settings.Setting.SAVE_TASK_DELAY.asInt());
                Bukkit.getPluginManager().callEvent((Event)new CitizensEnableEvent());
            }
        }, 1L) == -1) {
            Messaging.severeTr("citizens.load-task-error", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    @Override
    public void onImplementationChanged() {
        Messaging.severeTr("citizens.changed-implementation", new Object[0]);
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    public void registerCommandClass(Class<?> clazz) {
        try {
            this.commands.register(clazz);
        }
        catch (Throwable ex) {
            Messaging.logTr("citizens.commands.invalid.class", new Object[0]);
            ex.printStackTrace();
        }
    }

    private void registerCommands() {
        this.commands.setInjector(new Injector(this));
        this.commands.registerAnnotationProcessor(new RequirementsProcessor());
        this.commands.register(AdminCommands.class);
        this.commands.register(EditorCommands.class);
        this.commands.register(HelpCommands.class);
        this.commands.register(NPCCommands.class);
        this.commands.register(ScriptCommands.class);
        this.commands.register(TemplateCommands.class);
        this.commands.register(TraitCommands.class);
        this.commands.register(WaypointCommands.class);
    }

    private void registerScriptHelpers() {
        ScriptCompiler compiler = CitizensAPI.getScriptCompiler();
        compiler.registerGlobalContextProvider(new EventRegistrar(this));
        compiler.registerGlobalContextProvider(new ObjectProvider("plugin", this));
    }

    public void reload() throws NPCLoadException {
        Editor.leaveAll();
        this.config.reload();
        this.despawnNPCs();
        this.saves.loadInto(this.npcRegistry);
        this.getServer().getPluginManager().callEvent((Event)new CitizensReloadEvent());
    }

    private void scheduleSaveTask(int delay) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Citizens.this.storeNPCs();
                Citizens.this.saves.saveToDisk();
            }
        });
    }

    private void setupEconomy() {
        try {
            RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Economy.class);
            if (provider != null && provider.getProvider() != null) {
                Economy economy = (Economy)provider.getProvider();
                Bukkit.getPluginManager().registerEvents((Listener)new PaymentListener(economy), (Plugin)this);
            }
        }
        catch (NoClassDefFoundError e) {
            Messaging.logTr("citizens.economy.error-loading", new Object[0]);
        }
    }

    private void setupTranslator() {
        Locale locale = Locale.getDefault();
        String setting = Settings.Setting.LOCALE.asString();
        if (!setting.isEmpty()) {
            String[] parts = setting.split("[\\._]");
            switch (parts.length) {
                case 1: {
                    locale = new Locale(parts[0]);
                    break;
                }
                case 2: {
                    locale = new Locale(parts[0], parts[1]);
                    break;
                }
                case 3: {
                    locale = new Locale(parts[0], parts[1], parts[2]);
                    break;
                }
            }
        }
        Translator.setInstance(new File(this.getDataFolder(), "lang"), locale);
    }

    private void startMetrics() {
        try {
            Metrics metrics = new Metrics(this);
            if (metrics.isOptOut()) {
                return;
            }
            metrics.addCustomData(new Metrics.Plotter("Total NPCs"){

                @Override
                public int getValue() {
                    if (Citizens.this.npcRegistry == null) {
                        return 0;
                    }
                    return Iterables.size((Iterable)Citizens.this.npcRegistry);
                }
            });
            metrics.addCustomData(new Metrics.Plotter("Total goals"){

                @Override
                public int getValue() {
                    if (Citizens.this.npcRegistry == null) {
                        return 0;
                    }
                    int goalCount = 0;
                    for (NPC npc : Citizens.this.npcRegistry) {
                        goalCount += Iterables.size((Iterable)npc.getDefaultGoalController());
                    }
                    return goalCount;
                }
            });
            this.traitFactory.addPlotters(metrics.createGraph("traits"));
            this.saves.addPlotters(metrics.createGraph("Storage type"));
            metrics.start();
        }
        catch (IOException e) {
            Messaging.logTr("citizens.notifications.metrics-load-error", e.getMessage());
        }
    }

    public void storeNPCs() {
        if (this.saves == null) {
            return;
        }
        for (NPC npc : this.npcRegistry) {
            this.saves.store(npc);
        }
    }

    public void storeNPCs(CommandContext args) {
        this.storeNPCs();
        boolean async = args.hasFlag('a');
        if (async) {
            this.saves.saveToDisk();
        } else {
            this.saves.saveToDiskImmediate();
        }
    }

    private boolean suggestClosestModifier(CommandSender sender, String command, String modifier) {
        String closest = this.commands.getClosestCommandModifier(command, modifier);
        if (!closest.isEmpty()) {
            sender.sendMessage(ChatColor.GRAY + Messaging.tr("citizens.commands.unknown-command", new Object[0]));
            sender.sendMessage(StringHelper.wrap(" /") + command + " " + StringHelper.wrap(closest));
            return true;
        }
        return false;
    }
}

