/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import com.google.common.base.Function;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.Composite;

public class Selector
extends Composite {
    private Behavior executing;
    private boolean retryChildren = false;
    private final Function<List<Behavior>, Behavior> selectionFunction;
    private static final Random RANDOM = new Random();
    private static final Function<List<Behavior>, Behavior> RANDOM_SELECTION = new Function<List<Behavior>, Behavior>(){

        public Behavior apply(@Nullable List<Behavior> behaviors) {
            return behaviors.get(RANDOM.nextInt(behaviors.size()));
        }
    };

    private Selector(Function<List<Behavior>, Behavior> selectionFunction, boolean retryChildren, Collection<Behavior> behaviors) {
        super(behaviors);
        this.selectionFunction = selectionFunction;
        this.retryChildren = retryChildren;
    }

    protected Behavior getNextBehavior() {
        return (Behavior)this.selectionFunction.apply(this.getBehaviors());
    }

    @Override
    public void reset() {
        if (this.executing != null) {
            this.executing.reset();
        }
        this.executing = null;
    }

    @Override
    public BehaviorStatus run() {
        BehaviorStatus status;
        if (this.executing == null) {
            this.executing = this.getNextBehavior();
        }
        if ((status = this.executing.run()) == BehaviorStatus.FAILURE && this.retryChildren) {
            this.executing.reset();
            this.executing = this.getNextBehavior();
            return BehaviorStatus.RUNNING;
        }
        return status;
    }

    public static Builder selecting(Behavior ... behaviors) {
        return Selector.selecting(Arrays.asList(behaviors));
    }

    public static Builder selecting(Collection<Behavior> behaviors) {
        return new Builder(behaviors);
    }

    static /* synthetic */ Function access$000() {
        return RANDOM_SELECTION;
    }

    public static class Builder {
        private final Collection<Behavior> behaviors;
        private boolean retryChildren;
        private Function<List<Behavior>, Behavior> selectionFunction = Selector.access$000();

        private Builder(Collection<Behavior> behaviors) {
            this.behaviors = behaviors;
        }

        public Selector build() {
            return new Selector(this.selectionFunction, this.retryChildren, this.behaviors);
        }

        public Builder retryChildren(boolean retry) {
            this.retryChildren = retry;
            return this;
        }

        public Builder selectionFunction(Function<List<Behavior>, Behavior> function) {
            this.selectionFunction = function;
            return this;
        }
    }
}

