/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerRegistry;
import net.citizensnpcs.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;

public class TriggerAddPrompt
extends StringPrompt {
    private final WaypointEditor editor;

    public TriggerAddPrompt(WaypointEditor editor) {
        this.editor = editor;
    }

    public Prompt acceptInput(ConversationContext context, String input) {
        if ((input = input.toLowerCase().trim()).equalsIgnoreCase("back")) {
            context.setSessionData((Object)"said", (Object)false);
            return (Prompt)context.getSessionData((Object)"previous");
        }
        Prompt prompt = WaypointTriggerRegistry.getTriggerPromptFrom(input);
        if (prompt == null) {
            Messaging.sendErrorTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.add.invalid-trigger", input);
            context.setSessionData((Object)"said", (Object)false);
            return this;
        }
        return prompt;
    }

    public String getPromptText(ConversationContext context) {
        WaypointTrigger returned = (WaypointTrigger)context.getSessionData((Object)"created-trigger");
        if (returned != null) {
            if (this.editor.getCurrentWaypoint() != null) {
                this.editor.getCurrentWaypoint().addTrigger(returned);
                context.setSessionData((Object)"created-trigger", null);
                Messaging.sendTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.add.added", returned.description());
            } else {
                Messaging.sendErrorTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.main.missing-waypoint", new Object[0]);
            }
        }
        if (context.getSessionData((Object)"said") == Boolean.TRUE) {
            return "";
        }
        context.setSessionData((Object)"said", (Object)true);
        context.setSessionData((Object)"return-to", (Object)this);
        return Messaging.tr("citizens.editors.waypoints.triggers.add.prompt", WaypointTriggerRegistry.describeValidTriggerNames());
    }
}

