/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.command.command;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.command.command.Requirements;
import net.citizensnpcs.util.Paginator;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

@Requirements
public class HelpCommands {
    private final Citizens plugin;
    private static final String COMMAND_FORMAT = "<7>/<c>%s%s <7>- <e>%s";

    public HelpCommands(Citizens plugin) {
        this.plugin = plugin;
    }

    @Command(aliases={"citizens"}, usage="help (page|command)", desc="Citizens help menu", modifiers={"help"}, min=1, max=2, permission="help")
    @Requirements
    public void citizensHelp(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        int page = 1;
        try {
            page = args.argsLength() == 2 ? args.getInteger(1) : page;
        }
        catch (NumberFormatException e) {
            this.sendSpecificHelp(sender, "citizens", args.getString(1));
        }
        this.sendHelp(sender, "citizens", page);
    }

    private List<String> getLines(CommandSender sender, String baseCommand) {
        HashSet processed = Sets.newHashSet();
        ArrayList<String> lines = new ArrayList<String>();
        for (CommandManager.CommandInfo info : this.plugin.getCommands(baseCommand)) {
            Command command = info.getCommandAnnotation();
            if (processed.contains(info) || !sender.hasPermission("citizens.admin") && !sender.hasPermission("citizens." + command.permission())) continue;
            lines.add(HelpCommands.format(command));
            if (command.modifiers().length <= 1) continue;
            processed.add(info);
        }
        return lines;
    }

    @Command(aliases={"npc"}, usage="help (page|command)", desc="NPC help menu", modifiers={"help"}, min=1, max=2, permission="npc.help")
    @Requirements
    public void npcHelp(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        int page = 1;
        try {
            page = args.argsLength() == 2 ? args.getInteger(1) : page;
        }
        catch (NumberFormatException e) {
            this.sendSpecificHelp(sender, "npc", args.getString(1));
        }
        this.sendHelp(sender, "NPC", page);
    }

    @Command(aliases={"script"}, usage="help (page|command)", desc="Script help menu", modifiers={"help"}, min=1, max=2, permission="script.help")
    @Requirements
    public void scriptHelp(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        int page = 1;
        try {
            page = args.argsLength() == 2 ? args.getInteger(1) : page;
        }
        catch (NumberFormatException e) {
            this.sendSpecificHelp(sender, "script", args.getString(1));
        }
        this.sendHelp(sender, "script", page);
    }

    private void sendHelp(CommandSender sender, String name, int page) throws CommandException {
        Paginator paginator = new Paginator().header(StringHelper.capitalize(name) + Messaging.tr("citizens.commands.help.header", new Object[0]));
        for (String line : this.getLines(sender, name.toLowerCase())) {
            paginator.addLine(line);
        }
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", page);
        }
    }

    private void sendSpecificHelp(CommandSender sender, String rootCommand, String modifier) throws CommandException {
        CommandManager.CommandInfo info = this.plugin.getCommandInfo(rootCommand, modifier);
        if (info == null) {
            throw new CommandException("citizens.commands.help.command-missing", rootCommand + " " + modifier);
        }
        Messaging.send(sender, HelpCommands.format(info.getCommandAnnotation()));
        String help = Messaging.tryTranslate(info.getCommandAnnotation().help());
        if (help.isEmpty()) {
            return;
        }
        Messaging.send(sender, ChatColor.AQUA + help);
    }

    @Command(aliases={"template", "tpl"}, usage="help (page|command)", desc="Template help menu", modifiers={"help"}, min=1, max=2, permission="templates.help")
    @Requirements
    public void templatesHelp(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        int page = 1;
        try {
            page = args.argsLength() == 2 ? args.getInteger(1) : page;
        }
        catch (NumberFormatException e) {
            this.sendSpecificHelp(sender, "templates", args.getString(1));
        }
        this.sendHelp(sender, "templates", page);
    }

    @Command(aliases={"waypoint", "waypoint", "wp"}, usage="help (page|command)", desc="Waypoints help menu", modifiers={"help"}, min=1, max=2, permission="waypoints.help")
    @Requirements
    public void waypointsHelp(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        int page = 1;
        try {
            page = args.argsLength() == 2 ? args.getInteger(1) : page;
        }
        catch (NumberFormatException e) {
            this.sendSpecificHelp(sender, "waypoints", args.getString(1));
        }
        this.sendHelp(sender, "waypoints", page);
    }

    private static final String format(Command command) {
        return String.format(COMMAND_FORMAT, command.aliases()[0], command.usage().isEmpty() ? "" : " " + command.usage(), Messaging.tryTranslate(command.desc()));
    }
}

