/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.citizensnpcs.EventListen;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.EntityController;
import net.citizensnpcs.npc.ai.CitizensNavigator;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_4_R1.Entity;
import net.minecraft.server.v1_4_R1.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class CitizensNPC
extends AbstractNPC {
    private EntityController entityController;
    private final CitizensNavigator navigator = new CitizensNavigator(this);
    private static final String NPC_METADATA_MARKER = "NPC";

    public CitizensNPC(int id, String name, EntityController entityController) {
        super(id, name);
        Preconditions.checkNotNull((Object)entityController);
        this.entityController = entityController;
    }

    @Override
    public boolean despawn(DespawnReason reason) {
        if (!this.isSpawned()) {
            Messaging.debug("Tried to despawn", this.getId(), "while already despawned.");
            return false;
        }
        NPCDespawnEvent event = new NPCDespawnEvent(this, reason);
        if (reason == DespawnReason.CHUNK_UNLOAD) {
            event.setCancelled(Settings.Setting.KEEP_CHUNKS_LOADED.asBoolean());
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.getBukkitEntity().getLocation().getChunk().load();
            Messaging.debug("Couldn't despawn", this.getId(), "due to despawn event cancellation. Force loaded chunk.");
            return false;
        }
        boolean keepSelected = this.getTrait(Spawned.class).shouldSpawn();
        if (!keepSelected) {
            this.data().remove("selectors");
        }
        for (Trait trait : this.traits.values()) {
            trait.onDespawn();
        }
        this.entityController.remove();
        return true;
    }

    @Override
    public LivingEntity getBukkitEntity() {
        return this.entityController.getBukkitEntity();
    }

    @Deprecated
    public EntityLiving getHandle() {
        return ((CraftLivingEntity)this.getBukkitEntity()).getHandle();
    }

    @Override
    public Navigator getNavigator() {
        return this.navigator;
    }

    @Override
    public boolean isSpawned() {
        return this.getBukkitEntity() != null;
    }

    public void load(final DataKey root) {
        this.metadata.loadFrom(root.getRelative("metadata"));
        String traitNames = root.getString("traitnames");
        HashSet keys = Sets.newHashSet(root.getRelative("traits").getSubKeys());
        Iterables.addAll((Collection)keys, (Iterable)Iterables.transform((Iterable)Splitter.on((char)',').split((CharSequence)traitNames), (Function)new Function<String, DataKey>(){

            public DataKey apply(@Nullable String input) {
                return root.getRelative("traits." + input);
            }
        }));
        for (DataKey traitKey : keys) {
            Trait trait;
            if (traitKey.keyExists("enabled") && !traitKey.getBoolean("enabled") && traitKey.getRaw("enabled") instanceof Boolean) continue;
            Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(traitKey.name());
            if (this.hasTrait(clazz)) {
                trait = this.getTrait(clazz);
            } else {
                trait = CitizensAPI.getTraitFactory().getTrait(clazz);
                if (trait == null) {
                    Messaging.severeTr("citizens.notifications.skipping-broken-trait", traitKey.name(), this.getId());
                    continue;
                }
                this.addTrait(trait);
            }
            this.loadTrait(trait, traitKey);
        }
        CurrentLocation spawnLocation = this.getTrait(CurrentLocation.class);
        if (this.getTrait(Spawned.class).shouldSpawn() && spawnLocation.getLocation() != null) {
            this.spawn(spawnLocation.getLocation());
        }
        this.navigator.load(root.getRelative("navigator"));
    }

    private void loadTrait(Trait trait, DataKey traitKey) {
        try {
            trait.load(traitKey);
            PersistenceLoader.load(trait, traitKey);
        }
        catch (Throwable ex) {
            Messaging.logTr("citizens.notifications.trait-load-failed", traitKey.name(), this.getId());
        }
    }

    @Override
    public void save(DataKey root) {
        super.save(root);
        this.navigator.save(root.getRelative("navigator"));
    }

    public void setEntityController(EntityController newController) {
        Preconditions.checkNotNull((Object)newController);
        boolean wasSpawned = this.isSpawned();
        Location prev = null;
        if (wasSpawned) {
            prev = this.getBukkitEntity().getLocation();
            this.despawn();
        }
        this.entityController = newController;
        if (wasSpawned) {
            this.spawn(prev);
        }
    }

    @Override
    public boolean spawn(Location at) {
        boolean couldSpawn;
        Preconditions.checkNotNull((Object)at, (Object)"location cannot be null");
        if (this.isSpawned()) {
            Messaging.debug("Tried to spawn", this.getId(), "while already spawned.");
            return false;
        }
        this.entityController.spawn(at, this);
        EntityLiving mcEntity = ((CraftLivingEntity)this.getBukkitEntity()).getHandle();
        boolean bl = couldSpawn = !Util.isLoaded(at) ? false : mcEntity.world.addEntity((Entity)mcEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        if (!couldSpawn) {
            Messaging.debug("Retrying spawn of", this.getId(), "later due to chunk being unloaded.");
            this.entityController.remove();
            EventListen.addForRespawn(at, this.getId());
            return true;
        }
        NPCSpawnEvent spawnEvent = new NPCSpawnEvent(this, at);
        Bukkit.getPluginManager().callEvent((Event)spawnEvent);
        if (spawnEvent.isCancelled()) {
            this.entityController.remove();
            Messaging.debug("Couldn't spawn", this.getId(), "due to event cancellation.");
            return false;
        }
        NMS.setHeadYaw(mcEntity, at.getYaw());
        this.getBukkitEntity().setMetadata(NPC_METADATA_MARKER, (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)true));
        this.getTrait(CurrentLocation.class).setLocation(at);
        this.getTrait(Spawned.class).setSpawned(true);
        this.navigator.onSpawn();
        for (Trait trait : this.traits.values()) {
            trait.onSpawn();
        }
        this.getBukkitEntity().setRemoveWhenFarAway(false);
        return true;
    }

    @Override
    public void update() {
        try {
            super.update();
            if (this.isSpawned()) {
                NMS.trySwim(this.getBukkitEntity());
                this.navigator.run();
            }
        }
        catch (Exception ex) {
            Messaging.logTr("citizens.notifications.exception-updating-npc", this.getId(), ex.getMessage());
            ex.printStackTrace();
        }
    }
}

