/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.text;

import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.text.PageChangePrompt;
import net.citizensnpcs.trait.text.Text;
import net.citizensnpcs.trait.text.TextEditPrompt;
import net.citizensnpcs.trait.text.TextStartPrompt;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;

public class TextEditStartPrompt
extends StringPrompt {
    private final Text text;

    public TextEditStartPrompt(Text text) {
        this.text = text;
    }

    public Prompt acceptInput(ConversationContext context, String input) {
        Player player = (Player)context.getForWhom();
        try {
            int index = Integer.parseInt(input);
            if (!this.text.hasIndex(index)) {
                Messaging.sendErrorTr((CommandSender)player, "citizens.editors.text.invalid-index", index);
                return new TextStartPrompt(this.text);
            }
            context.setSessionData((Object)"index", (Object)index);
            return new TextEditPrompt(this.text);
        }
        catch (NumberFormatException ex) {
            if (input.equalsIgnoreCase("page")) {
                context.setSessionData((Object)"previous", (Object)this);
                return new PageChangePrompt(this.text);
            }
            Messaging.sendErrorTr((CommandSender)player, "citizens.editors.text.invalid-input", new Object[0]);
            return new TextStartPrompt(this.text);
        }
    }

    public String getPromptText(ConversationContext context) {
        this.text.sendPage((Player)context.getForWhom(), 1);
        return Messaging.tr("citizens.editors.text.edit-begin-prompt", new Object[0]);
    }
}

