/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.collect.Lists;
import java.util.List;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.triggers.ChatTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerPrompt;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;

public class ChatTriggerPrompt
extends StringPrompt
implements WaypointTriggerPrompt {
    private final List<String> lines = Lists.newArrayList();
    private double radius = -1.0;

    public Prompt acceptInput(ConversationContext context, String input) {
        if (input.equalsIgnoreCase("back")) {
            return (Prompt)context.getSessionData((Object)"previous");
        }
        if (input.startsWith("radius")) {
            try {
                this.radius = Double.parseDouble(input.split(" ")[1]);
            }
            catch (NumberFormatException e) {
                Messaging.sendErrorTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.chat.invalid-radius", new Object[0]);
            }
            catch (IndexOutOfBoundsException e) {
                Messaging.sendErrorTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.chat.missing-radius", new Object[0]);
            }
            return this;
        }
        if (input.equalsIgnoreCase("finish")) {
            context.setSessionData((Object)"created-trigger", (Object)new ChatTrigger(this.radius, this.lines));
            return (Prompt)context.getSessionData((Object)"return-to");
        }
        this.lines.add(input);
        return this;
    }

    public String getPromptText(ConversationContext context) {
        Messaging.sendTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.chat.prompt", new Object[0]);
        return "";
    }
}

